/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1Hugepages;

/**
 * Memory allows specifying the VirtualMachineInstance memory features.
 */
@ApiModel(description = "Memory allows specifying the VirtualMachineInstance memory features.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Memory {
  @SerializedName("guest")
  private String guest = null;

  @SerializedName("hugepages")
  private V1Hugepages hugepages = null;

  public V1Memory guest(String guest) {
    this.guest = guest;
    return this;
  }

   /**
   * Guest allows to specifying the amount of memory which is visible inside the Guest OS. The Guest must lie between Requests and Limits from the resources section. Defaults to the requested memory in the resources section if not specified. + optional
   * @return guest
  **/
  @ApiModelProperty(value = "Guest allows to specifying the amount of memory which is visible inside the Guest OS. The Guest must lie between Requests and Limits from the resources section. Defaults to the requested memory in the resources section if not specified. + optional")
  public String getGuest() {
    return guest;
  }

  public void setGuest(String guest) {
    this.guest = guest;
  }

  public V1Memory hugepages(V1Hugepages hugepages) {
    this.hugepages = hugepages;
    return this;
  }

   /**
   * Hugepages allow to use hugepages for the VirtualMachineInstance instead of regular memory. +optional
   * @return hugepages
  **/
  @ApiModelProperty(value = "Hugepages allow to use hugepages for the VirtualMachineInstance instead of regular memory. +optional")
  public V1Hugepages getHugepages() {
    return hugepages;
  }

  public void setHugepages(V1Hugepages hugepages) {
    this.hugepages = hugepages;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Memory v1Memory = (V1Memory) o;
    return Objects.equals(this.guest, v1Memory.guest) &&
        Objects.equals(this.hugepages, v1Memory.hugepages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(guest, hugepages);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Memory {\n");
    
    sb.append("    guest: ").append(toIndentedString(guest)).append("\n");
    sb.append("    hugepages: ").append(toIndentedString(hugepages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

