/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionBuilder;
import org.ovirt.engine.sdk4.types.StorageConnection;

public interface StorageServerConnectionsService extends Service {
    /**
     * Creates a new storage connection.
     * 
     * For example, to create a new storage connection for the NFS server `mynfs.example.com` and NFS share
     * `/export/mydata` send a request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/storageconnections
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection>
     *   <type>nfs</type>
     *   <address>mynfs.example.com</address>
     *   <path>/export/mydata</path>
     *   <host>
     *     <name>myhost</name>
     *   </host>
     * </storage_connection>
     * ----
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest connection(StorageConnection connection);
        AddRequest connection(StorageConnectionBuilder connection);
    }
    
    /**
     * Creates a new storage connection.
     * 
     * For example, to create a new storage connection for the NFS server `mynfs.example.com` and NFS share
     * `/export/mydata` send a request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/storageconnections
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection>
     *   <type>nfs</type>
     *   <address>mynfs.example.com</address>
     *   <path>/export/mydata</path>
     *   <host>
     *     <name>myhost</name>
     *   </host>
     * </storage_connection>
     * ----
     */
    public interface AddResponse extends Response {
        StorageConnection connection();
    }
    
    /**
     * Creates a new storage connection.
     * 
     * For example, to create a new storage connection for the NFS server `mynfs.example.com` and NFS share
     * `/export/mydata` send a request like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/storageconnections
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <storage_connection>
     *   <type>nfs</type>
     *   <address>mynfs.example.com</address>
     *   <path>/export/mydata</path>
     *   <host>
     *     <name>myhost</name>
     *   </host>
     * </storage_connection>
     * ----
     */
    AddRequest add();
    
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of connections to return. If not specified all the connections are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of connections to return. If not specified all the connections are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of connections to return. If not specified all the connections are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    public interface ListResponse extends Response {
        List<StorageConnection> connections();
    }
    
    ListRequest list();
    
    StorageServerConnectionService storageConnectionService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

