/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ImageContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.types.Image;

public class XmlImageReader {
    public static Image readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        ImageContainer object = new ImageContainer();
        block22: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block22;
                }
                case "id": {
                    object.id(image);
                    continue block22;
                }
            }
        }
        reader.next();
        block23: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block23;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block23;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block23;
                }
                case "storage_domain": {
                    object.storageDomain(XmlStorageDomainReader.readOne(reader));
                    continue block23;
                }
                case "link": {
                    XmlImageReader.readLink(reader, object);
                    continue block23;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Image> iterateMany(final XmlReader reader) {
        return new Iterator<Image>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Image next() {
                Image next = XmlImageReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Image> readMany(XmlReader reader) {
        ArrayList<Image> list = new ArrayList<Image>();
        Iterator<Image> iterator = XmlImageReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, ImageContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

