/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.List;
import org.ovirt.engine.sdk4.types.PolicyUnitType;
import org.ovirt.engine.sdk4.types.Property;
import org.ovirt.engine.sdk4.types.SchedulingPolicyUnit;

public class SchedulingPolicyUnitContainer extends IdentifiedContainer implements SchedulingPolicyUnit {
    private Boolean enabled;
    private Boolean internal;
    private List<Property> properties;
    private PolicyUnitType type;
    
    public boolean enabled() {
        return enabled;
    }
    
    public void enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
    }
    
    public void enabled(Boolean newEnabled) {
        enabled = newEnabled;
    }
    
    public boolean enabledPresent() {
        return enabled != null;
    }
    
    public boolean internal() {
        return internal;
    }
    
    public void internal(boolean newInternal) {
        internal = Boolean.valueOf(newInternal);
    }
    
    public void internal(Boolean newInternal) {
        internal = newInternal;
    }
    
    public boolean internalPresent() {
        return internal != null;
    }
    
    public List<Property> properties() {
        return makeUnmodifiableList(properties);
    }
    
    public void properties(List<Property> newProperties) {
        properties = makeArrayList(newProperties);
    }
    
    public boolean propertiesPresent() {
        return properties != null && !properties.isEmpty();
    }
    
    public PolicyUnitType type() {
        return type;
    }
    
    public void type(PolicyUnitType newType) {
        type = newType;
    }
    
    public boolean typePresent() {
        return type != null;
    }
    
}
