/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.FileBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.FloppyContainer;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Floppy;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class FloppyBuilder {
    private String comment;
    private String description;
    private File file;
    private String href;
    private String id;
    private InstanceType instanceType;
    private String name;
    private Template template;
    private Vm vm;
    private List<Vm> vms;

    public FloppyBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public FloppyBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public FloppyBuilder file(File newFile) {
        this.file = newFile;
        return this;
    }

    public FloppyBuilder file(FileBuilder newFile) {
        this.file = newFile == null ? null : newFile.build();
        return this;
    }

    public FloppyBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public FloppyBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public FloppyBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public FloppyBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public FloppyBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public FloppyBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public FloppyBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public FloppyBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public FloppyBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public FloppyBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public FloppyBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public FloppyBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public Floppy build() {
        FloppyContainer container = new FloppyContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.file(this.file);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.name(this.name);
        container.template(this.template);
        container.vm(this.vm);
        container.vms(this.vms);
        return container;
    }
}

