/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.internal.containers.QuotaClusterLimitContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaClusterLimit;

public class QuotaClusterLimitBuilder {
    private Cluster cluster;
    private String comment;
    private String description;
    private String href;
    private String id;
    private BigDecimal memoryLimit;
    private BigDecimal memoryUsage;
    private String name;
    private Quota quota;
    private BigInteger vcpuLimit;
    private BigInteger vcpuUsage;

    public QuotaClusterLimitBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public QuotaClusterLimitBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public QuotaClusterLimitBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public QuotaClusterLimitBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public QuotaClusterLimitBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public QuotaClusterLimitBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public QuotaClusterLimitBuilder memoryLimit(float newMemoryLimit) {
        this.memoryLimit = BigDecimal.valueOf(newMemoryLimit);
        return this;
    }

    public QuotaClusterLimitBuilder memoryLimit(Float newMemoryLimit) {
        this.memoryLimit = newMemoryLimit == null ? null : BigDecimal.valueOf(newMemoryLimit.doubleValue());
        return this;
    }

    public QuotaClusterLimitBuilder memoryLimit(double newMemoryLimit) {
        this.memoryLimit = BigDecimal.valueOf(newMemoryLimit);
        return this;
    }

    public QuotaClusterLimitBuilder memoryLimit(Double newMemoryLimit) {
        this.memoryLimit = newMemoryLimit == null ? null : BigDecimal.valueOf(newMemoryLimit);
        return this;
    }

    public QuotaClusterLimitBuilder memoryLimit(BigDecimal newMemoryLimit) {
        this.memoryLimit = newMemoryLimit;
        return this;
    }

    public QuotaClusterLimitBuilder memoryUsage(float newMemoryUsage) {
        this.memoryUsage = BigDecimal.valueOf(newMemoryUsage);
        return this;
    }

    public QuotaClusterLimitBuilder memoryUsage(Float newMemoryUsage) {
        this.memoryUsage = newMemoryUsage == null ? null : BigDecimal.valueOf(newMemoryUsage.doubleValue());
        return this;
    }

    public QuotaClusterLimitBuilder memoryUsage(double newMemoryUsage) {
        this.memoryUsage = BigDecimal.valueOf(newMemoryUsage);
        return this;
    }

    public QuotaClusterLimitBuilder memoryUsage(Double newMemoryUsage) {
        this.memoryUsage = newMemoryUsage == null ? null : BigDecimal.valueOf(newMemoryUsage);
        return this;
    }

    public QuotaClusterLimitBuilder memoryUsage(BigDecimal newMemoryUsage) {
        this.memoryUsage = newMemoryUsage;
        return this;
    }

    public QuotaClusterLimitBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public QuotaClusterLimitBuilder quota(Quota newQuota) {
        this.quota = newQuota;
        return this;
    }

    public QuotaClusterLimitBuilder quota(QuotaBuilder newQuota) {
        this.quota = newQuota == null ? null : newQuota.build();
        return this;
    }

    public QuotaClusterLimitBuilder vcpuLimit(int newVcpuLimit) {
        this.vcpuLimit = BigInteger.valueOf(newVcpuLimit);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuLimit(Integer newVcpuLimit) {
        this.vcpuLimit = newVcpuLimit == null ? null : BigInteger.valueOf(newVcpuLimit.longValue());
        return this;
    }

    public QuotaClusterLimitBuilder vcpuLimit(long newVcpuLimit) {
        this.vcpuLimit = BigInteger.valueOf(newVcpuLimit);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuLimit(Long newVcpuLimit) {
        this.vcpuLimit = newVcpuLimit == null ? null : BigInteger.valueOf(newVcpuLimit);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuLimit(BigInteger newVcpuLimit) {
        this.vcpuLimit = newVcpuLimit;
        return this;
    }

    public QuotaClusterLimitBuilder vcpuUsage(int newVcpuUsage) {
        this.vcpuUsage = BigInteger.valueOf(newVcpuUsage);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuUsage(Integer newVcpuUsage) {
        this.vcpuUsage = newVcpuUsage == null ? null : BigInteger.valueOf(newVcpuUsage.longValue());
        return this;
    }

    public QuotaClusterLimitBuilder vcpuUsage(long newVcpuUsage) {
        this.vcpuUsage = BigInteger.valueOf(newVcpuUsage);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuUsage(Long newVcpuUsage) {
        this.vcpuUsage = newVcpuUsage == null ? null : BigInteger.valueOf(newVcpuUsage);
        return this;
    }

    public QuotaClusterLimitBuilder vcpuUsage(BigInteger newVcpuUsage) {
        this.vcpuUsage = newVcpuUsage;
        return this;
    }

    public QuotaClusterLimit build() {
        QuotaClusterLimitContainer container = new QuotaClusterLimitContainer();
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.memoryLimit(this.memoryLimit);
        container.memoryUsage(this.memoryUsage);
        container.name(this.name);
        container.quota(this.quota);
        container.vcpuLimit(this.vcpuLimit);
        container.vcpuUsage(this.vcpuUsage);
        return container;
    }
}

