/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.services.CopyableService;
import org.ovirt.engine.sdk4.types.Action;

public class CopyableServiceImpl
extends ServiceImpl
implements CopyableService {
    public CopyableServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public CopyableService.CopyRequest copy() {
        return new CopyRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "CopyableService:" + this.getPath();
    }

    private class CopyResponseImpl
    implements CopyableService.CopyResponse {
        private CopyResponseImpl() {
        }
    }

    private class CopyRequestImpl
    extends BaseRequest<CopyableService.CopyRequest, CopyableService.CopyResponse>
    implements CopyableService.CopyRequest {
        private Boolean async;

        private CopyRequestImpl() {
        }

        @Override
        public CopyableService.CopyRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public CopyableService.CopyResponse send() {
            HttpPost request = new HttpPost(CopyableServiceImpl.this.getConnection().getUrl() + CopyableServiceImpl.this.getPath() + "/copy");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = CopyableServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = CopyableServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new CopyResponseImpl();
        }
    }
}

