/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.StorageConnectionContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterVolumeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNfsVersionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageTypeReader;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class XmlStorageConnectionReader {
    public static StorageConnection readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        StorageConnectionContainer object = new StorageConnectionContainer();
        block50: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block50;
                }
                case "id": {
                    object.id(image);
                    continue block50;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block51: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block51;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block51;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block51;
                }
                case "gluster_volume": {
                    object.glusterVolume(XmlGlusterVolumeReader.readOne(reader));
                    continue block51;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block51;
                }
                case "mount_options": {
                    object.mountOptions(reader.readString());
                    continue block51;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block51;
                }
                case "nfs_retrans": {
                    object.nfsRetrans(reader.readInteger());
                    continue block51;
                }
                case "nfs_timeo": {
                    object.nfsTimeo(reader.readInteger());
                    continue block51;
                }
                case "nfs_version": {
                    object.nfsVersion(XmlNfsVersionReader.readOne(reader));
                    continue block51;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block51;
                }
                case "path": {
                    object.path(reader.readString());
                    continue block51;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block51;
                }
                case "portal": {
                    object.portal(reader.readString());
                    continue block51;
                }
                case "target": {
                    object.target(reader.readString());
                    continue block51;
                }
                case "type": {
                    object.type(XmlStorageTypeReader.readOne(reader));
                    continue block51;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block51;
                }
                case "vfs_type": {
                    object.vfsType(reader.readString());
                    continue block51;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block51;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlStorageConnectionReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<StorageConnection> iterateMany(final XmlReader reader) {
        return new Iterator<StorageConnection>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public StorageConnection next() {
                StorageConnection next = XmlStorageConnectionReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<StorageConnection> readMany(XmlReader reader) {
        ArrayList<StorageConnection> list = new ArrayList<StorageConnection>();
        Iterator<StorageConnection> iterator = XmlStorageConnectionReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(StorageConnectionContainer object, String[] link) {
    }
}

