/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VirtualNumaNodeBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVirtualNumaNodeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVirtualNumaNodeWriter;
import org.ovirt.engine.sdk4.services.VmNumaNodeService;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;

public class VmNumaNodeServiceImpl
extends ServiceImpl
implements VmNumaNodeService {
    public VmNumaNodeServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmNumaNodeService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmNumaNodeService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public VmNumaNodeService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "VmNumaNodeService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements VmNumaNodeService.UpdateResponse {
        private VirtualNumaNode node;

        private UpdateResponseImpl() {
        }

        public void node(VirtualNumaNode node) {
            this.node = node;
        }

        @Override
        public VirtualNumaNode node() {
            return this.node;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<VmNumaNodeService.UpdateRequest, VmNumaNodeService.UpdateResponse>
    implements VmNumaNodeService.UpdateRequest {
        private Boolean async;
        private VirtualNumaNode node;

        private UpdateRequestImpl() {
        }

        @Override
        public VmNumaNodeService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNumaNodeService.UpdateRequest node(VirtualNumaNode node) {
            this.node = node;
            return this;
        }

        @Override
        public VmNumaNodeService.UpdateRequest node(VirtualNumaNodeBuilder node) {
            this.node = node.build();
            return this;
        }

        @Override
        public VmNumaNodeService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNumaNodeServiceImpl.this.getConnection().getUrl() + VmNumaNodeServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVirtualNumaNodeWriter.writeOne(this.node, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNumaNodeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.node(XmlVirtualNumaNodeReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNumaNodeServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements VmNumaNodeService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<VmNumaNodeService.RemoveRequest, VmNumaNodeService.RemoveResponse>
    implements VmNumaNodeService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public VmNumaNodeService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmNumaNodeService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNumaNodeServiceImpl.this.getConnection().getUrl() + VmNumaNodeServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNumaNodeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            VmNumaNodeServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements VmNumaNodeService.GetResponse {
        private VirtualNumaNode node;

        private GetResponseImpl() {
        }

        public void node(VirtualNumaNode node) {
            this.node = node;
        }

        @Override
        public VirtualNumaNode node() {
            return this.node;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmNumaNodeService.GetRequest, VmNumaNodeService.GetResponse>
    implements VmNumaNodeService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmNumaNodeService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmNumaNodeService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNumaNodeServiceImpl.this.getConnection().getUrl() + VmNumaNodeServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNumaNodeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.node(XmlVirtualNumaNodeReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNumaNodeServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

