/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.internal.containers.MigrationOptionsContainer;
import org.ovirt.engine.sdk4.types.InheritableBoolean;
import org.ovirt.engine.sdk4.types.MigrationBandwidth;
import org.ovirt.engine.sdk4.types.MigrationOptions;
import org.ovirt.engine.sdk4.types.MigrationPolicy;

public class MigrationOptionsBuilder {
    private InheritableBoolean autoConverge;
    private MigrationBandwidth bandwidth;
    private InheritableBoolean compressed;
    private InheritableBoolean encrypted;
    private MigrationPolicy policy;
    
    public MigrationOptionsBuilder autoConverge(InheritableBoolean newAutoConverge) {
        autoConverge = newAutoConverge;
        return this;
    }
    
    
    public MigrationOptionsBuilder bandwidth(MigrationBandwidth newBandwidth) {
        bandwidth = newBandwidth;
        return this;
    }
    
    public MigrationOptionsBuilder bandwidth(MigrationBandwidthBuilder newBandwidth) {
        if (newBandwidth == null) {
            bandwidth = null;
        }
        else {
            bandwidth = newBandwidth.build();
        }
        return this;
    }
    
    
    public MigrationOptionsBuilder compressed(InheritableBoolean newCompressed) {
        compressed = newCompressed;
        return this;
    }
    
    
    public MigrationOptionsBuilder encrypted(InheritableBoolean newEncrypted) {
        encrypted = newEncrypted;
        return this;
    }
    
    
    public MigrationOptionsBuilder policy(MigrationPolicy newPolicy) {
        policy = newPolicy;
        return this;
    }
    
    public MigrationOptionsBuilder policy(MigrationPolicyBuilder newPolicy) {
        if (newPolicy == null) {
            policy = null;
        }
        else {
            policy = newPolicy.build();
        }
        return this;
    }
    
    
    public MigrationOptions build() {
        MigrationOptionsContainer container = new MigrationOptionsContainer();
        container.autoConverge(autoConverge);
        container.bandwidth(bandwidth);
        container.compressed(compressed);
        container.encrypted(encrypted);
        container.policy(policy);
        return container;
    }
}
