/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackSubnetBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.OpenstackSubnetServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackSubnetReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackSubnetWriter;
import org.ovirt.engine.sdk4.services.OpenstackSubnetService;
import org.ovirt.engine.sdk4.services.OpenstackSubnetsService;
import org.ovirt.engine.sdk4.types.OpenStackSubnet;

public class OpenstackSubnetsServiceImpl
extends ServiceImpl
implements OpenstackSubnetsService {
    public OpenstackSubnetsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackSubnetsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public OpenstackSubnetsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public OpenstackSubnetService subnetService(String id) {
        return new OpenstackSubnetServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.subnetService(path);
        }
        return this.subnetService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "OpenstackSubnetsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements OpenstackSubnetsService.ListResponse {
        private List<OpenStackSubnet> subnets;

        private ListResponseImpl() {
        }

        public void subnets(List<OpenStackSubnet> subnets) {
            this.subnets = subnets;
        }

        @Override
        public List<OpenStackSubnet> subnets() {
            return this.subnets;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<OpenstackSubnetsService.ListRequest, OpenstackSubnetsService.ListResponse>
    implements OpenstackSubnetsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public OpenstackSubnetsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackSubnetsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public OpenstackSubnetsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public OpenstackSubnetsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public OpenstackSubnetsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackSubnetsServiceImpl.this.getConnection().getUrl() + OpenstackSubnetsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackSubnetsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.subnets(XmlOpenStackSubnetReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackSubnetsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements OpenstackSubnetsService.AddResponse {
        private OpenStackSubnet subnet;

        private AddResponseImpl() {
        }

        public void subnet(OpenStackSubnet subnet) {
            this.subnet = subnet;
        }

        @Override
        public OpenStackSubnet subnet() {
            return this.subnet;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<OpenstackSubnetsService.AddRequest, OpenstackSubnetsService.AddResponse>
    implements OpenstackSubnetsService.AddRequest {
        private OpenStackSubnet subnet;

        private AddRequestImpl() {
        }

        @Override
        public OpenstackSubnetsService.AddRequest subnet(OpenStackSubnet subnet) {
            this.subnet = subnet;
            return this;
        }

        @Override
        public OpenstackSubnetsService.AddRequest subnet(OpenStackSubnetBuilder subnet) {
            this.subnet = subnet.build();
            return this;
        }

        @Override
        public OpenstackSubnetsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackSubnetsServiceImpl.this.getConnection().getUrl() + OpenstackSubnetsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenStackSubnetWriter.writeOne(this.subnet, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackSubnetsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.subnet(XmlOpenStackSubnetReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackSubnetsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

