/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.xml.XmlFaultReader;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Fault;

public class ServiceImpl {
    private String path;
    private HttpConnection connection;

    public ServiceImpl() {
        this.connection = null;
        this.path = null;
    }

    public ServiceImpl(HttpConnection connection, String path) {
        this.connection = connection;
        this.path = path;
    }

    public void checkFault(HttpResponse response) {
        try (XmlReader reader = new XmlReader(response.getEntity().getContent());){
            Fault fault = null;
            try {
                fault = XmlFaultReader.readOne(reader);
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
            if (fault != null || response.getStatusLine() != null && response.getStatusLine().getStatusCode() >= 400) {
                this.throwError(response, fault);
            }
        }
        catch (IOException ex) {
            throw new Error("Failed to read response", ex);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public Action checkAction(HttpResponse response) {
        try {
            XmlReader reader = new XmlReader(response.getEntity().getContent());
            try {
                Object result = reader.read();
                if (result != null) {
                    if (result instanceof Fault) {
                        this.throwError(response, (Fault)result);
                    } else if (result instanceof Action && ((Action)result).faultPresent()) {
                        this.throwError(response, ((Action)result).fault());
                    }
                }
                Action action = (Action)result;
                reader.close();
                return action;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new Error("Failed to read response", ex);
                }
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public void throwError(HttpResponse response, Fault fault) {
        StringBuilder buffer = new StringBuilder();
        if (fault != null) {
            if (fault.reasonPresent()) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(String.format("Fault reason is \"%s\".", fault.reason()));
            }
            if (fault.detailPresent()) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(String.format("Fault detail is \"%s\".", fault.detail()));
            }
        }
        if (response != null && response.getStatusLine() != null) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(String.format("HTTP response code is \"%s\".", response.getStatusLine().getStatusCode()));
            buffer.append(" ");
            buffer.append(String.format("HTTP response message is \"%s\".", response.getStatusLine().getReasonPhrase()));
        }
        throw new Error(buffer.toString());
    }

    public HttpConnection getConnection() {
        return this.connection;
    }

    public String getPath() {
        return this.path;
    }
}

