/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateDiskAttachmentServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskAttachmentReader;
import org.ovirt.engine.sdk4.services.TemplateDiskAttachmentService;
import org.ovirt.engine.sdk4.services.TemplateDiskAttachmentsService;
import org.ovirt.engine.sdk4.types.DiskAttachment;

public class TemplateDiskAttachmentsServiceImpl
extends ServiceImpl
implements TemplateDiskAttachmentsService {
    public TemplateDiskAttachmentsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplateDiskAttachmentsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public TemplateDiskAttachmentService attachmentService(String id) {
        return new TemplateDiskAttachmentServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.attachmentService(path);
        }
        return this.attachmentService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "TemplateDiskAttachmentsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements TemplateDiskAttachmentsService.ListResponse {
        private List<DiskAttachment> attachments;

        private ListResponseImpl() {
        }

        public void attachments(List<DiskAttachment> attachments) {
            this.attachments = attachments;
        }

        @Override
        public List<DiskAttachment> attachments() {
            return this.attachments;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<TemplateDiskAttachmentsService.ListRequest, TemplateDiskAttachmentsService.ListResponse>
    implements TemplateDiskAttachmentsService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public TemplateDiskAttachmentsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplateDiskAttachmentsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateDiskAttachmentsServiceImpl.this.getConnection().getUrl() + TemplateDiskAttachmentsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateDiskAttachmentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.attachments(XmlDiskAttachmentReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateDiskAttachmentsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

