/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ExternalHostProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalComputeResourcesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalDiscoveredHostsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalHostGroupsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalHostsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderCertificatesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderWriter;
import org.ovirt.engine.sdk4.services.ExternalComputeResourcesService;
import org.ovirt.engine.sdk4.services.ExternalDiscoveredHostsService;
import org.ovirt.engine.sdk4.services.ExternalHostGroupsService;
import org.ovirt.engine.sdk4.services.ExternalHostProviderService;
import org.ovirt.engine.sdk4.services.ExternalHostsService;
import org.ovirt.engine.sdk4.services.ExternalProviderCertificatesService;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public class ExternalHostProviderServiceImpl
extends ExternalProviderServiceImpl
implements ExternalHostProviderService {
    public ExternalHostProviderServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostProviderService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public ExternalHostProviderService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public ExternalHostProviderService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public ExternalProviderCertificatesService certificatesService() {
        return new ExternalProviderCertificatesServiceImpl(this.getConnection(), this.getPath() + "/certificates");
    }

    @Override
    public ExternalComputeResourcesService computeResourcesService() {
        return new ExternalComputeResourcesServiceImpl(this.getConnection(), this.getPath() + "/computeresources");
    }

    @Override
    public ExternalDiscoveredHostsService discoveredHostsService() {
        return new ExternalDiscoveredHostsServiceImpl(this.getConnection(), this.getPath() + "/discoveredhosts");
    }

    @Override
    public ExternalHostGroupsService hostGroupsService() {
        return new ExternalHostGroupsServiceImpl(this.getConnection(), this.getPath() + "/hostgroups");
    }

    @Override
    public ExternalHostsService hostsService() {
        return new ExternalHostsServiceImpl(this.getConnection(), this.getPath() + "/hosts");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("certificates")) {
            return this.certificatesService();
        }
        if (path.startsWith("certificates/")) {
            return this.certificatesService().service(path.substring(13));
        }
        if (path.equals("computeresources")) {
            return this.computeResourcesService();
        }
        if (path.startsWith("computeresources/")) {
            return this.computeResourcesService().service(path.substring(17));
        }
        if (path.equals("discoveredhosts")) {
            return this.discoveredHostsService();
        }
        if (path.startsWith("discoveredhosts/")) {
            return this.discoveredHostsService().service(path.substring(16));
        }
        if (path.equals("hostgroups")) {
            return this.hostGroupsService();
        }
        if (path.startsWith("hostgroups/")) {
            return this.hostGroupsService().service(path.substring(11));
        }
        if (path.equals("hosts")) {
            return this.hostsService();
        }
        if (path.startsWith("hosts/")) {
            return this.hostsService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "ExternalHostProviderService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements ExternalHostProviderService.UpdateResponse {
        private ExternalHostProvider provider;

        private UpdateResponseImpl() {
        }

        public void provider(ExternalHostProvider provider) {
            this.provider = provider;
        }

        @Override
        public ExternalHostProvider provider() {
            return this.provider;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<ExternalHostProviderService.UpdateRequest, ExternalHostProviderService.UpdateResponse>
    implements ExternalHostProviderService.UpdateRequest {
        private Boolean async;
        private ExternalHostProvider provider;

        private UpdateRequestImpl() {
        }

        @Override
        public ExternalHostProviderService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ExternalHostProviderService.UpdateRequest provider(ExternalHostProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public ExternalHostProviderService.UpdateRequest provider(ExternalHostProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public ExternalHostProviderService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostProviderServiceImpl.this.getConnection().getUrl() + ExternalHostProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlExternalHostProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.provider(XmlExternalHostProviderReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostProviderServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements ExternalHostProviderService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<ExternalHostProviderService.RemoveRequest, ExternalHostProviderService.RemoveResponse>
    implements ExternalHostProviderService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public ExternalHostProviderService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public ExternalHostProviderService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostProviderServiceImpl.this.getConnection().getUrl() + ExternalHostProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            ExternalHostProviderServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements ExternalHostProviderService.GetResponse {
        private ExternalHostProvider provider;

        private GetResponseImpl() {
        }

        public void provider(ExternalHostProvider provider) {
            this.provider = provider;
        }

        @Override
        public ExternalHostProvider provider() {
            return this.provider;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ExternalHostProviderService.GetRequest, ExternalHostProviderService.GetResponse>
    implements ExternalHostProviderService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ExternalHostProviderService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostProviderService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostProviderServiceImpl.this.getConnection().getUrl() + ExternalHostProviderServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.provider(XmlExternalHostProviderReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostProviderServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

