/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiskType {
    DATA("data"),
    SYSTEM("system");

    private static final Logger log;
    private String image;

    private DiskType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static DiskType fromValue(String value) {
        try {
            return DiskType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'DiskType' enumerated type. Valid values are 'data' and 'system'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(DiskType.class);
    }
}

