/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.HostDeviceBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmHostDeviceServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlHostDeviceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostDeviceWriter;
import org.ovirt.engine.sdk4.services.VmHostDeviceService;
import org.ovirt.engine.sdk4.services.VmHostDevicesService;
import org.ovirt.engine.sdk4.types.HostDevice;

public class VmHostDevicesServiceImpl
extends ServiceImpl
implements VmHostDevicesService {
    public VmHostDevicesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmHostDevicesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmHostDevicesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmHostDeviceService deviceService(String id) {
        return new VmHostDeviceServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.deviceService(path);
        }
        return this.deviceService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmHostDevicesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmHostDevicesService.ListResponse {
        private List<HostDevice> device;

        private ListResponseImpl() {
        }

        public void device(List<HostDevice> device) {
            this.device = device;
        }

        @Override
        public List<HostDevice> device() {
            return this.device;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmHostDevicesService.ListRequest, VmHostDevicesService.ListResponse>
    implements VmHostDevicesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmHostDevicesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmHostDevicesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmHostDevicesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmHostDevicesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmHostDevicesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmHostDevicesServiceImpl.this.getConnection().getUrl() + VmHostDevicesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmHostDevicesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.device(XmlHostDeviceReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmHostDevicesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmHostDevicesService.AddResponse {
        private HostDevice device;

        private AddResponseImpl() {
        }

        public void device(HostDevice device) {
            this.device = device;
        }

        @Override
        public HostDevice device() {
            return this.device;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmHostDevicesService.AddRequest, VmHostDevicesService.AddResponse>
    implements VmHostDevicesService.AddRequest {
        private HostDevice device;

        private AddRequestImpl() {
        }

        @Override
        public VmHostDevicesService.AddRequest device(HostDevice device) {
            this.device = device;
            return this;
        }

        @Override
        public VmHostDevicesService.AddRequest device(HostDeviceBuilder device) {
            this.device = device.build();
            return this;
        }

        @Override
        public VmHostDevicesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmHostDevicesServiceImpl.this.getConnection().getUrl() + VmHostDevicesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlHostDeviceWriter.writeOne(this.device, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmHostDevicesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.device(XmlHostDeviceReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmHostDevicesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

