%global rolename image-template
%global roleprefix oVirt.
%global roleprefix_legacy ovirt-
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-image-template
Summary: Ansible role to create virtual machine template from disk image
Version: 1.1.6
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-image-template/ovirt-ansible-image-template-1.1.6.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.5

%description
This Ansible role provide funtionality to create virtual machine template from disk
image.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}"
st = posix.stat(path)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Tue Apr 10 2018 Ondra Machacek <omachace@redhat.com> - 1.1.6-1
- Require Ansible 2.5.

* Wed Jan 17 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Support RHV credentials for Ansible Tower/AWX.

* Tue Dec 12 2017 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Package missing vars/ directory.

* Mon Dec 04 2017 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Add %pretrans scriplet to remove legacy role name.

* Wed Nov 29 2017 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Rename prefix ovirt. to oVirt. to sync with galaxy

* Mon Nov 27 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- Initial release
