%global rolename repositories
%global roleprefix ovirt.
%global roleprefix_legacy_uppercase oVirt.
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-repositories
Summary: Ansible role to setup oVirt/RHV repositories
Version: 1.2.4
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-repositories/ovirt-ansible-repositories-1.2.4.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.9.0

%description
This Ansible role is used to set up the repositories required for
oVirt engine or host installation.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path_uppercase = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}"

st = posix.stat(path_uppercase)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_uppercase..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY_UPPERCASE=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Tue Jul 14 2020 Martin Necas <mnecas@redhat.com> - 1.2.4-1
- Remove 4.4-beta repositories
- Add 4.4 repositories

* Wed May 13 2020 Martin Necas <mnecas@redhat.com> - 1.2.3-1
- Add 4.4-beta repositories

* Tue May 5 2020 Martin Necas <mnecas@redhat.com> - 1.2.2-1
- Add dnf modules

* Mon Dec 2 2019 Martin Necas <mnecas@redhat.com> - 1.2.1-1
- Add build for el8.

* Tue Nov 19 2019 Martin Necas <mnecas@redhat.com> - 1.2.0-1
- Bump ansible to 2.9

* Tue Feb 19 2019 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Add 4.3 repositories

* Wed Jan 23 2019 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Add correct JBoss channel.

* Fri Nov 30 2018 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Require Ansible 2.7.2.
- Support ovirt.repositories name.
- Fix backup repos issue.

* Tue Sep 18 2018 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Add ovirt_repositories_pools var.
- Ensure subscription-manager package is present.
- Add force_register option.

* Thu Dec 07 2017 Katerina Koukiou <kkoukiou@redhat.com> - 1.1.0-1
- Initial release
