%global ansible_roles_dir ansible/roles

%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	BUILD_VALIDATION=0

Name: ovirt-ansible-roles
Summary: Set of Ansible roles for oVirt management
Version: 1.0.4
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-roles/ovirt-ansible-roles-1.0.4.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.3.1
Requires: python2-jmespath

%description
Collection of Ansible roles to ease the management and automation of the oVirt engine.

%prep
%setup -c -q

%build
make %{make_common_opts} dist

%install
make %{make_common_opts} install DESTDIR="%{buildroot}" ANSIBLE_DATA_DIR="%{_datadir}/%{ansible_roles_dir}"

%files
%{_datadir}/%{ansible_roles_dir}

%doc %{_docdir}/%{name}/README.md
%doc %{_docdir}/%{name}/examples/
%doc %{_docdir}/%{ansible_roles_dir}/

%license %{_docdir}/%{name}/LICENSE

%changelog
* Thu Sep 21 2017 Ondra Machacek <omachace@redhat.com> - 1.0.4-1
- Fix ovirt-image-template parameters. rhbz #1489454
- Improve shutdown of non-migrable VMs. rhbz #1488526
- Require ansible 2.3.1.
- Vm infra fix defaults. rhbz #1489893
- Add memory_guaranteed parameter to ovirt-vm-infra. rhbz #1490852
- Add sockets variable to ovirt-vm-infra role. rhbz #1489888
- Add nics to ovirt-vm-infra role. rhbz #1490934
- Add timeouts for ovirt-vm-infra role. #1490838
- Improve reinstalling of the hosts.
- Don't hot-plug disk. rhbz #1490930
- Don't run with cloud-init if not specified.
- Add suffix to modules with bug fixes. rhbz #1487082
- Rebase ovirt_vms module with Ansible fix #27382. rhbz #1491010

* Fri Sep 1 2017 Ondra Machacek <omachace@redhat.com> - 1.0.3-1
- Fix REAME.md getting started instruction.
- Add dependency for python2-jmespath package.

* Thu Aug 31 2017 Ondra Machacek <omachace@redhat.com> - 1.0.2-1
- Update library of ovirt-cluster-ugprade role.
- Added Getting Started information.

* Wed Aug 16 2017 Ondra Machacek <omachace@redhat.com> - 1.0.1-1
- Remove ovirt. prefix from role names.
- Add affinity group role.
- Documentation improvements.

* Tue Jul 25 2017 Ondra Machacek <omachace@redhat.com> - 1.0.0-1
- Initial release.
