%global ansible_roles_dir ansible/roles
%global ansible_hostdeploy_post_tasks ovirt-host-deploy-post-tasks.yml

%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	BUILD_VALIDATION=0

Name: ovirt-ansible-roles
Summary: Set of Ansible roles for oVirt management
Version: 1.1.1
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-roles/ovirt-ansible-roles-1.1.1.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.4

%description
Collection of Ansible roles to ease the management and automation of the oVirt engine.

%prep
%setup -c -q

%build
make %{make_common_opts} dist

%install
make %{make_common_opts} install DESTDIR="%{buildroot}" ANSIBLE_DATA_DIR="%{_datadir}/%{ansible_roles_dir}" POST_TASKS_FILE=%{ansible_hostdeploy_post_tasks}

%files
%{_datadir}/%{ansible_roles_dir}
%{_datadir}/%{name}/playbooks

%{_sysconfdir}/%{name}/%{ansible_hostdeploy_post_tasks}

%doc %{_docdir}/%{name}/README.md
%doc %{_docdir}/%{name}/examples/
%doc %{_docdir}/%{ansible_roles_dir}/

%license %{_docdir}/%{name}/LICENSE

%changelog
* Tue Oct 24 2017 Ondra Machacek <omachace@redhat.com> - 1.1.1-1
- ovirt-cluster-upgrade: Don't run check_for upgrade if not needed (#64)
- ovirt-image-template: add image_cache_download option (#63)
- Add new ovirt-host-deploy-facts role and use it in ovirt-host-deploy-firewalld role (#71)
- oVirt provider OVN driver (#73)
- Improve shutdown of non-migrable VMs (#76)
- Fix ovirt-image-template parameters (#78)
- Vm infra fix defaults (#80)
- Add memory_guaranteed parameter to ovirt-vm-infra (#81)
- Add sockets variable to ovirt-vm-infra role
- Add nics to ovirt-vm-infra role (#83)
- Add timeouts for ovirt-vm-infra role (#82)
- Libvirt guests (#62)
- Require Ansible 2.4
- ovirt-ansible: roles: Add role to cleanup datacenter (#84)
- Add host-upgrade role (#106)

* Tue Aug 29 2017 Ondra Machacek <omachace@redhat.com> - 1.1.0-1
- ovirt-image-template: add glance as disk source (#30)
- ovirt-vm-infra: allow set state and sd for vm (#37)
- introduce ovirt set mac pool role (#24)
- introduce ovirt-external-provider role (#20)
- ovirt-host-deploy: Add firewalld role (#7)

* Wed Aug 16 2017 Ondra Machacek <omachace@redhat.com> - 1.0.1-1
- Remove ovirt. prefix from role names.
- Add affinity group role.
- Documentation improvements.

* Tue Jul 25 2017 Ondra Machacek <omachace@redhat.com> - 1.0.0-1
- Initial release.
