%global rolename v2v-conversion-host
%global roleprefix oVirt.
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-v2v-conversion-host
Summary: Ansible role to setup oVirt host as conversion host for ManageIQ
Version: 1.9.1
Release: 1%{?release_suffix}%{?dist}
Source0: https://github.com/oVirt/ovirt-ansible-v2v-conversion-host/releases/download/v%{version}/%{name}-%{version}.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.4

%description
This Ansible role allows one to setup oVirt host as conversion host for ManageIQ.

%prep
%setup -c -q

%build

%install
export DATAROOT_DIR=%{_datadir}
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export AUX_DATA_DIR=%{buildroot}%{_datadir}/%{name}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{name}/*

%doc README.md
%doc docs/
%doc examples/

%license LICENSE

%changelog
* Tue Jan 22 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.9.1-1
- Wrapper changes:
  * Fix regex matching OSP volume IDs (BZ#1668049)
- Roles changes:
  * Fix path to wrapper in uninstallation task
  * Change again how we configure SSH keys for VMware; use only single key for
    all hosts

* Mon Jan  7 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.9.0-1
- Wrapper changes:
  * Prevent passwords leaking in error reports from failed openstack commands
- Roles changes:
  * Allow setting SSH connection to VMware hosts via a variable and
    remove inventory approach for SSH keys
  * Add ability to set maximum concurrent conversions in ManageIQ
  * Variabilize certificate validation for ManageIQ
  * Remove repositories configuration

* Wed Dec  5 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.8.0-1
- Wrapper changes:
  * Fix check for ISO domains in RHV
  * Set security groups on ports instead of instances (BZ#1654861)
  * Allow disabling of SSL verification for OSP
  * Remove OSP volumes from destination project
  * Fix OSP commands to operate in destination project
- Roles changes:
  * Add configuration of SSH transport: install private keys for VMware hosts and set .ssh/config
  * Add configuration of ca-trust for providers certificates to avoid using insecure connection
  * Add creation of ManageIQ conversion host record and tagging of associated resource
  * Allow to not configure VDDK if vddk transport method is not set for conversion host
  * Tasks heavily reorganized
  * Remove nbdkit-* uninstallation as it also uninstalls vdsm

* Thu Oct 18 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.7.0-1
- Wrapper changes
  - general refactoring to support different conversion targets
  - drop dependency on subprocess32
  - add support for OpenStack
- Roles changes
  - add support for OpenStack

* Wed Aug 29 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.6.3-1
- Roles changes:
  - make nbdkit checking code compatible with current EL

* Wed Aug 29 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.6.2-1
- Roles changes:
  - VDDK plugin is not built for new nbdkit
  - make sure installed packages are at latest version
  - make sure oVirt SDK is installed

* Fri Aug 10 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.6.1-1
- Wrapper fixes:
  - fixed problem with incorrect disk paths when using SSH transport
  - accept more names of guest tools ISOs
  - fix incorrect ordering of guest tools ISOs
  - add check for virt-v2v capabilities to prevent MAC address based network
    mapping from failing migration

* Wed Aug  1 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.6.0-1
- Wrapper changes:
  - Fixed issues with handling of UTF-8 names
  - Added check for existance of guest tools ISO
  - Added check for minimal oVirt/RHV version
  - Added --vesrion option
  - Added support for virt-v2v --mac option
- Roles changes:
  - VDDK package URL is optional
  - Added checks for RHV version and existence of ISO with guest tools

* Sun Jul  1 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.5.0-1
- wrapper changes:
  - clean disks on conversion failure
  - don't look for ISOs on block storage domains

* Fri Jun 15 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.4.1-1
- wrapper: fix problem with missing symbol

* Thu Jun 14 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.4.0-1
- wrapper changes:
  - set stdin for virt-v2v to /dev/null
  - pass --root=first argument and -oo rhv-verifypeer=false on insecure connection
  - add support for reading SSH key from input
- install playbooks into secondary location
- point to sources on GitHub

* Wed May 30 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.3.1-1
- wrapper: fix syntax error

* Wed May 30 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.3.0-1
- add SSH transport method
- changes in wrapper:
  - use vdsm user
  - add insecure_connection and install_drivers keys

* Sun May 20 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.2.0-1
- wrapper: add version number, assume allocation based on storage
* Thu Apr 12 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.1.2-1
- wrapper: fix license boiler plate
* Thu Apr 12 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.1.1-1
- wrapper: allow just filenames in virtio_win key
- roles: create nbdkit repo file condionaly
* Mon Apr  9 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.1.0-1
- wrapper: added network_mappings and virtio_win keys to input data
* Wed Mar 28 2018 Tomáš Golembiovský <tgolembi@redhat.com> 1.0.0-1
- Initial release
