# Copyright (C) 2017 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%global         package_version 1.0.0

%global metrics_data %{_datadir}/ovirt-engine-metrics
%global metrics_etc %{_sysconfdir}/ovirt-engine-metrics

%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	BUILD_VALIDATION=0

Summary:        oVirt Engine Metrics
Name:           ovirt-engine-metrics
Version:        1.0.0
Release:        1%{?release_suffix}%{?dist}
Source0:        http://resources.ovirt.org/pub/src/ovirt-engine-metrics/ovirt-engine-metrics-1.0.0.tar.gz
License:        ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires:       ovirt-engine
Requires:	ovirt-engine-setup-plugin-ovirt-engine-common >= 4.1
Requires:	ovirt-engine-setup-plugin-ovirt-engine >= 4.1
Requires:	ansible >= 2.2.0

# In oVirt 4.1.0, content of this package was in a different one, which was
# built from the engine sources.
Obsoletes:	ovirt-engine-hosts-ansible-inventory
Provides:	ovirt-engine-hosts-ansible-inventory

%description
ovirt-engine-metrics allows configuring an oVirt installation to send metrics
data to a remote fluentd/elasticsearch store.

%prep
%setup -c -q

%build
make %{make_common_opts}

%install
make %{make_common_opts} install DESTDIR="%{buildroot}"

%clean
rm -rf %{buildroot}

%files
%license LICENSE
%{metrics_data}/setup/bin
%{metrics_data}/setup/ansible
%{metrics_etc}
%doc README.md

%changelog
* Sun Feb 12 2017 Shirly Radco <sradco@redhat.com> - 1.0.0-0.0.master
- initial packaging

