/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondNetworkLabel;
import org.ovirt.engine.sdk.entities.Label;
import org.ovirt.engine.sdk.entities.Labels;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterIscsiBondNetworkLabels
extends CollectionDecorator<Label, Labels, DataCenterIscsiBondNetworkLabel> {
    private DataCenterIscsiBondNetwork parent;

    public DataCenterIscsiBondNetworkLabels(HttpProxyBroker proxy, DataCenterIscsiBondNetwork parent) {
        super(proxy, "labels");
        this.parent = parent;
    }

    @Override
    public List<DataCenterIscsiBondNetworkLabel> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Labels.class, DataCenterIscsiBondNetworkLabel.class);
    }

    @Override
    public DataCenterIscsiBondNetworkLabel get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Label.class, DataCenterIscsiBondNetworkLabel.class);
    }

    @Override
    public DataCenterIscsiBondNetworkLabel getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Label.class, DataCenterIscsiBondNetworkLabel.class);
    }

    public DataCenterIscsiBondNetworkLabel add(Label label) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, label, Label.class, DataCenterIscsiBondNetworkLabel.class, headers);
    }

    public List<DataCenterIscsiBondNetworkLabel> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Labels.class, DataCenterIscsiBondNetworkLabel.class, headers);
    }
}

