/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VM;
import org.ovirt.engine.sdk.decorators.VMStatistic;
import org.ovirt.engine.sdk.entities.Statistic;
import org.ovirt.engine.sdk.entities.Statistics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class VMStatistics
extends CollectionDecorator<Statistic, Statistics, VMStatistic> {
    private VM parent;

    public VMStatistics(HttpProxyBroker proxy, VM parent) {
        super(proxy, "statistics");
        this.parent = parent;
    }

    @Override
    public List<VMStatistic> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Statistics.class, VMStatistic.class);
    }

    @Override
    public VMStatistic get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Statistic.class, VMStatistic.class);
    }

    @Override
    public VMStatistic getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Statistic.class, VMStatistic.class);
    }
}

