/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.jgroups;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.JGroupsBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.jgroups.JChannelWrapper;
import org.jboss.logging.Logger;

public class JChannelManager {
    private static final Logger logger = Logger.getLogger(JChannelManager.class);
    private Map<String, JChannelWrapper> channels;

    public synchronized JChannelWrapper getJChannel(String channelName, JGroupsBroadcastEndpoint endpoint) throws Exception {
        JChannelWrapper wrapper;
        if (this.channels == null) {
            this.channels = new HashMap<String, JChannelWrapper>();
        }
        if ((wrapper = this.channels.get(channelName)) == null) {
            wrapper = new JChannelWrapper(this, channelName, endpoint.createChannel());
            this.channels.put(channelName, wrapper);
            if (logger.isTraceEnabled()) {
                logger.trace("Put Channel " + channelName);
            }
            return wrapper;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Add Ref Count " + channelName);
        }
        return wrapper.addRef();
    }

    public synchronized void removeChannel(String channelName) {
        this.channels.remove(channelName);
    }
}

