/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider.jwt;

import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.claims.ClaimsUtils;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.request.Lifetime;
import org.apache.cxf.sts.request.Participants;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderUtils;
import org.apache.cxf.sts.token.provider.jwt.JWTClaimsProvider;
import org.apache.cxf.sts.token.provider.jwt.JWTClaimsProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;

public class DefaultJWTClaimsProvider
implements JWTClaimsProvider {
    public static final long DEFAULT_MAX_LIFETIME = 43200L;
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultJWTClaimsProvider.class);
    private boolean useX500CN;
    private long lifetime = 1800L;
    private long maxLifetime = 43200L;
    private boolean failLifetimeExceedance = true;
    private boolean acceptClientLifetime;
    private long futureTimeToLive = 60L;

    @Override
    public JwtClaims getJwtClaims(JWTClaimsProviderParameters jwtClaimsProviderParameters) {
        JwtClaims claims = new JwtClaims();
        claims.setSubject(this.getSubjectName(jwtClaimsProviderParameters));
        claims.setTokenId(UUID.randomUUID().toString());
        String issuer = jwtClaimsProviderParameters.getIssuer();
        if (issuer == null) {
            STSPropertiesMBean stsProperties = jwtClaimsProviderParameters.getProviderParameters().getStsProperties();
            claims.setIssuer(stsProperties.getIssuer());
        } else {
            claims.setIssuer(issuer);
        }
        this.handleWSTrustClaims(jwtClaimsProviderParameters, claims);
        this.handleConditions(jwtClaimsProviderParameters, claims);
        this.handleAudienceRestriction(jwtClaimsProviderParameters, claims);
        return claims;
    }

    protected String getSubjectName(JWTClaimsProviderParameters jwtClaimsProviderParameters) {
        Principal principal = this.getPrincipal(jwtClaimsProviderParameters);
        if (principal == null) {
            LOG.fine("Error in getting principal");
            throw new STSException("Error in getting principal", STSException.REQUEST_FAILED);
        }
        String subjectName = principal.getName();
        if (principal instanceof X500Principal) {
            try {
                String principalName = principal.getName();
                int index = principalName.indexOf(61);
                subjectName = principalName = principalName.substring(index + 1, principalName.indexOf(44, index));
            }
            catch (Throwable ex) {
                subjectName = principal.getName();
            }
        }
        return subjectName;
    }

    protected Principal getPrincipal(JWTClaimsProviderParameters jwtClaimsProviderParameters) {
        TokenProviderParameters providerParameters = jwtClaimsProviderParameters.getProviderParameters();
        Principal principal = null;
        if (providerParameters.getTokenRequirements().getOnBehalfOf() != null) {
            ReceivedToken receivedToken = providerParameters.getTokenRequirements().getOnBehalfOf();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else if (providerParameters.getTokenRequirements().getActAs() != null) {
            ReceivedToken receivedToken = providerParameters.getTokenRequirements().getActAs();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else if (providerParameters.getTokenRequirements().getValidateTarget() != null) {
            ReceivedToken receivedToken = providerParameters.getTokenRequirements().getValidateTarget();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else {
            principal = providerParameters.getPrincipal();
        }
        return principal;
    }

    protected void handleWSTrustClaims(JWTClaimsProviderParameters jwtClaimsProviderParameters, JwtClaims claims) {
        TokenProviderParameters providerParameters = jwtClaimsProviderParameters.getProviderParameters();
        ProcessedClaimCollection retrievedClaims = ClaimsUtils.processClaims(providerParameters);
        if (retrievedClaims != null) {
            for (ProcessedClaim claim : retrievedClaims) {
                if (claim.getClaimType() == null || claim.getValues() == null || claim.getValues().isEmpty()) continue;
                List claimValues = claim.getValues();
                if (claim.getValues().size() == 1) {
                    claimValues = claim.getValues().get(0);
                }
                claims.setProperty(claim.getClaimType().toString(), (Object)claimValues);
            }
        }
    }

    protected void handleConditions(JWTClaimsProviderParameters jwtClaimsProviderParameters, JwtClaims claims) {
        TokenProviderParameters providerParameters = jwtClaimsProviderParameters.getProviderParameters();
        Date currentDate = new Date();
        long currentTimeInSeconds = currentDate.getTime() / 1000L;
        claims.setIssuedAt(Long.valueOf(currentTimeInSeconds));
        claims.setNotBefore(Long.valueOf(currentTimeInSeconds));
        claims.setExpiryTime(Long.valueOf(currentTimeInSeconds + this.lifetime));
        Lifetime tokenLifetime = providerParameters.getTokenRequirements().getLifetime();
        if (this.lifetime > 0L && this.acceptClientLifetime && tokenLifetime != null && tokenLifetime.getCreated() != null && tokenLifetime.getExpires() != null) {
            try {
                XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
                Date creationTime = fmt.parse(tokenLifetime.getCreated());
                Date expirationTime = fmt.parse(tokenLifetime.getExpires());
                if (creationTime == null || expirationTime == null) {
                    LOG.fine("Error in parsing Timestamp Created or Expiration Strings");
                    throw new STSException("Error in parsing Timestamp Created or Expiration Strings", STSException.INVALID_TIME);
                }
                Date validCreation = new Date();
                long currentTime = validCreation.getTime();
                if (this.futureTimeToLive > 0L) {
                    validCreation.setTime(currentTime + this.futureTimeToLive * 1000L);
                }
                if (creationTime.after(validCreation)) {
                    LOG.fine("The Created Time is too far in the future");
                    throw new STSException("The Created Time is too far in the future", STSException.INVALID_TIME);
                }
                long requestedLifetime = expirationTime.getTime() - creationTime.getTime();
                if (requestedLifetime > this.getMaxLifetime() * 1000L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Requested lifetime [").append(requestedLifetime / 1000L);
                    sb.append(" sec] exceed configured maximum lifetime [").append(this.getMaxLifetime());
                    sb.append(" sec]");
                    LOG.warning(sb.toString());
                    if (this.isFailLifetimeExceedance()) {
                        throw new STSException("Requested lifetime exceeds maximum lifetime", STSException.INVALID_TIME);
                    }
                    expirationTime.setTime(creationTime.getTime() + this.getMaxLifetime() * 1000L);
                }
                long creationTimeInSeconds = creationTime.getTime() / 1000L;
                claims.setIssuedAt(Long.valueOf(creationTimeInSeconds));
                claims.setNotBefore(Long.valueOf(creationTimeInSeconds));
                claims.setExpiryTime(Long.valueOf(expirationTime.getTime() / 1000L));
            }
            catch (ParseException e) {
                LOG.warning("Failed to parse life time element: " + e.getMessage());
            }
        }
    }

    protected void handleAudienceRestriction(JWTClaimsProviderParameters jwtClaimsProviderParameters, JwtClaims claims) {
        Participants participants;
        TokenProviderParameters providerParameters = jwtClaimsProviderParameters.getProviderParameters();
        ArrayList<String> audiences = new ArrayList<String>();
        String appliesToAddress = providerParameters.getAppliesToAddress();
        if (appliesToAddress != null) {
            audiences.add(appliesToAddress);
        }
        if ((participants = providerParameters.getTokenRequirements().getParticipants()) != null) {
            String address = TokenProviderUtils.extractAddressFromParticipantsEPR(participants.getPrimaryParticipant());
            if (address != null) {
                audiences.add(address);
            }
            if (participants.getParticipants() != null) {
                for (Object participant : participants.getParticipants()) {
                    if (participant == null || (address = TokenProviderUtils.extractAddressFromParticipantsEPR(participant)) == null) continue;
                    audiences.add(address);
                }
            }
        }
        if (!audiences.isEmpty()) {
            claims.setAudiences(audiences);
        }
    }

    public boolean isUseX500CN() {
        return this.useX500CN;
    }

    public void setUseX500CN(boolean useX500CN) {
        this.useX500CN = useX500CN;
    }

    public long getFutureTimeToLive() {
        return this.futureTimeToLive;
    }

    public void setFutureTimeToLive(long futureTimeToLive) {
        this.futureTimeToLive = futureTimeToLive;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public boolean isAcceptClientLifetime() {
        return this.acceptClientLifetime;
    }

    public void setAcceptClientLifetime(boolean acceptClientLifetime) {
        this.acceptClientLifetime = acceptClientLifetime;
    }

    public boolean isFailLifetimeExceedance() {
        return this.failLifetimeExceedance;
    }

    public void setFailLifetimeExceedance(boolean failLifetimeExceedance) {
        this.failLifetimeExceedance = failLifetimeExceedance;
    }
}

