/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.Properties;
import javax.batch.operations.JobOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.BatchLogger;

abstract class JobOperationStepHandler
implements OperationStepHandler {
    private final boolean modify;

    protected JobOperationStepHandler() {
        this(true);
    }

    protected JobOperationStepHandler(boolean modify) {
        this.modify = modify;
    }

    public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceController controller = context.getServiceRegistry(this.modify).getService(BatchServiceNames.jobOperatorServiceName(address));
        JobOperator jobOperator = (JobOperator)controller.getService();
        this.execute(context, operation, jobOperator);
    }

    protected abstract void execute(OperationContext var1, ModelNode var2, JobOperator var3) throws OperationFailedException;

    static ModelNode resolveValue(OperationContext context, ModelNode operation, AttributeDefinition attribute) throws OperationFailedException {
        ModelNode value = new ModelNode();
        if (operation.has(attribute.getName())) {
            value.set(operation.get(attribute.getName()));
        }
        return attribute.resolveValue(context, value);
    }

    static Properties resolvePropertyValue(OperationContext context, ModelNode operation, AttributeDefinition attribute) throws OperationFailedException {
        Properties properties = new Properties();
        if (operation.hasDefined(attribute.getName())) {
            JobOperationStepHandler.resolveValue(context, operation, attribute).asPropertyList().forEach(p -> properties.put(p.getName(), p.getValue().asString()));
        }
        return properties;
    }

    static OperationFailedException createOperationFailure(Throwable cause) {
        String msg = cause.getLocalizedMessage();
        BatchLogger.LOGGER.debugf(cause, "Failed to process batch operation: %s", msg);
        return new OperationFailedException(msg, cause);
    }
}

