/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.OutboundTransformer;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;

public class AMQPNativeOutboundTransformer
extends OutboundTransformer {
    public AMQPNativeOutboundTransformer(IDGenerator idGenerator) {
        super(idGenerator);
    }

    @Override
    public long transform(ServerJMSMessage message, WritableBuffer buffer) throws JMSException, UnsupportedEncodingException {
        if (message == null || !(message instanceof ServerJMSBytesMessage)) {
            return 0L;
        }
        return AMQPNativeOutboundTransformer.transform(this, (ServerJMSBytesMessage)message, buffer);
    }

    public static long transform(OutboundTransformer options, ServerJMSBytesMessage message, WritableBuffer buffer) throws JMSException {
        byte[] data = new byte[(int)message.getBodyLength()];
        message.readBytes(data);
        message.reset();
        int amqpDeliveryCount = message.getDeliveryCount() - 1;
        if (amqpDeliveryCount >= 1) {
            int decoded;
            ProtonJMessage amqp = (ProtonJMessage)Message.Factory.create();
            int offset = 0;
            for (int len = data.length; len > 0; len -= decoded) {
                decoded = amqp.decode(data, offset, len);
                assert (decoded > 0) : "Make progress decoding the message";
                offset += decoded;
            }
            if (amqp.getHeader() == null && amqpDeliveryCount > 0) {
                amqp.setHeader(new Header());
            }
            amqp.getHeader().setDeliveryCount(new UnsignedInteger(amqpDeliveryCount));
            amqp.encode(buffer);
        } else {
            buffer.put(data, 0, data.length);
        }
        return 0L;
    }
}

