/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class CacheConfigurationBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<Configuration>,
Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> {
    private final ValueDependency<EvictionConfiguration> eviction;
    private final ValueDependency<ExpirationConfiguration> expiration;
    private final ValueDependency<LockingConfiguration> locking;
    private final ValueDependency<PersistenceConfiguration> persistence;
    private final ValueDependency<TransactionConfiguration> transaction;
    private final ValueDependency<Module> module;
    private final String containerName;
    private final String cacheName;
    private volatile Builder<Configuration> builder;
    private volatile JMXStatisticsConfiguration statistics;

    CacheConfigurationBuilder(PathAddress address) {
        super((Capability)CacheResourceDefinition.Capability.CONFIGURATION, address);
        this.containerName = address.getParent().getLastElement().getValue();
        this.cacheName = address.getLastElement().getValue();
        this.eviction = new InjectedValueDependency(CacheComponent.EVICTION.getServiceName(address), EvictionConfiguration.class);
        this.expiration = new InjectedValueDependency(CacheComponent.EXPIRATION.getServiceName(address), ExpirationConfiguration.class);
        this.locking = new InjectedValueDependency(CacheComponent.LOCKING.getServiceName(address), LockingConfiguration.class);
        this.persistence = new InjectedValueDependency(CacheComponent.PERSISTENCE.getServiceName(address), PersistenceConfiguration.class);
        this.transaction = new InjectedValueDependency(CacheComponent.TRANSACTION.getServiceName(address), TransactionConfiguration.class);
        this.module = new InjectedValueDependency(CacheComponent.MODULE.getServiceName(address), Module.class);
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder builder = this.builder.build(target);
        Stream.of(this.eviction, this.expiration, this.locking, this.persistence, this.transaction, this.module).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean enabled = CacheResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.statistics = new org.infinispan.configuration.cache.ConfigurationBuilder().jmxStatistics().enabled(enabled).available(enabled).create();
        this.builder = new ConfigurationBuilder(CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(context.getCurrentAddress()), this.containerName, this.cacheName, this.andThen(builder -> {
            CacheMode mode = builder.clustering().cacheMode();
            if (mode.isSynchronous() && ((TransactionConfiguration)this.transaction.getValue()).lockingMode() == LockingMode.OPTIMISTIC && ((LockingConfiguration)this.locking.getValue()).isolationLevel() == IsolationLevel.REPEATABLE_READ) {
                builder.locking().writeSkewCheck(true);
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
            GroupsConfigurationBuilder groupsBuilder = builder.clustering().hash().groups().enabled();
            ((Module)this.module.getValue()).loadService(Grouper.class).forEach(grouper -> groupsBuilder.addGrouper(grouper));
        })).configure(context);
        return this;
    }

    @Override
    public void accept(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        builder.eviction().read((EvictionConfiguration)this.eviction.getValue());
        builder.expiration().read((ExpirationConfiguration)this.expiration.getValue());
        builder.locking().read((LockingConfiguration)this.locking.getValue());
        builder.persistence().read((PersistenceConfiguration)this.persistence.getValue());
        builder.transaction().read((TransactionConfiguration)this.transaction.getValue());
        builder.jmxStatistics().read(this.statistics);
    }
}

