/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.AbstractEndpoint;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.InternalContextUtils;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;

public class Destination
extends AbstractEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(Destination.class);
    private Map<String, DestinationSequence> map = new ConcurrentHashMap<String, DestinationSequence>();

    Destination(RMEndpoint reliableEndpoint) {
        super(reliableEndpoint);
    }

    public DestinationSequence getSequence(Identifier id) {
        return this.map.get(id.getValue());
    }

    public Collection<DestinationSequence> getAllSequences() {
        return CastUtils.cast(this.map.values());
    }

    public void addSequence(DestinationSequence seq) {
        this.addSequence(seq, true);
    }

    public void addSequence(DestinationSequence seq, boolean persist) {
        RMStore store;
        seq.setDestination(this);
        this.map.put(seq.getIdentifier().getValue(), seq);
        if (persist && null != (store = this.getReliableEndpoint().getManager().getStore())) {
            store.createDestinationSequence(seq);
        }
        this.processingSequenceCount.incrementAndGet();
    }

    public void terminateSequence(DestinationSequence seq) {
        this.terminateSequence(seq, false);
    }

    public void terminateSequence(DestinationSequence seq, boolean forceRemove) {
        seq.terminate();
        if (forceRemove || seq.allAcknowledgedMessagesDelivered()) {
            this.removeSequence(seq);
        }
    }

    public void removeSequence(DestinationSequence seq) {
        DestinationSequence o = this.map.remove(seq.getIdentifier().getValue());
        RMStore store = this.getReliableEndpoint().getManager().getStore();
        if (null != store) {
            store.removeDestinationSequence(seq.getIdentifier());
        }
        if (o != null) {
            this.processingSequenceCount.decrementAndGet();
            this.completedSequenceCount.incrementAndGet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acknowledge(Message message) throws SequenceFault, RMException {
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        SequenceType sequenceType = rmps.getSequence();
        if (null == sequenceType) {
            return;
        }
        DestinationSequence seq = this.getSequence(sequenceType.getIdentifier());
        if (null != seq) {
            if (seq.applyDeliveryAssurance(sequenceType.getMessageNumber(), message)) {
                if (MessageUtils.isTrue((Object)message.get((Object)"org.apache.cxf.oneway.robust.delivering"))) {
                    return;
                }
                seq.acknowledge(message);
                if (null == rmps.getCloseSequence()) return;
                seq.setLastMessageNumber(sequenceType.getMessageNumber());
                this.ackImmediately(seq, message);
                return;
            } else {
                try {
                    Exchange exchange;
                    Conduit conduit;
                    message.getInterceptorChain().abort();
                    if (seq.sendAcknowledgement()) {
                        this.ackImmediately(seq, message);
                    }
                    if ((conduit = (exchange = message.getExchange()).getDestination().getBackChannel(message)) == null) return;
                    if (seq.sendAcknowledgement()) {
                        AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
                        InternalContextUtils.rebaseResponse(null, maps, message);
                        return;
                    }
                    Message response = Destination.createMessage(exchange);
                    response.setExchange(exchange);
                    response.remove((Object)"Content-Type");
                    conduit.prepare(response);
                    conduit.close(response);
                    return;
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage());
                    throw new RMException(e);
                }
            }
        } else {
            ProtocolVariation protocol = RMContextUtils.getProtocolVariation(message);
            RMConstants consts = protocol.getConstants();
            SequenceFaultFactory sff = new SequenceFaultFactory(consts);
            throw sff.createUnknownSequenceFault(sequenceType.getIdentifier());
        }
    }

    void ackRequested(Message message) throws SequenceFault, RMException {
        Collection<AckRequestedType> ars = RMContextUtils.retrieveRMProperties(message, false).getAcksRequested();
        if (null == ars) {
            return;
        }
        for (AckRequestedType ar : ars) {
            Identifier id = ar.getIdentifier();
            DestinationSequence seq = this.getSequence(id);
            if (null == seq) continue;
            this.ackImmediately(seq, message);
        }
    }

    void ackImmediately(DestinationSequence seq, Message message) throws RMException {
        seq.scheduleImmediateAcknowledgement();
        AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
        String replyToAddress = null;
        if (null != maps.getReplyTo()) {
            replyToAddress = maps.getReplyTo().getAddress().getValue();
        }
        if (!seq.getAcksTo().getAddress().getValue().equals(replyToAddress) && !seq.canPiggybackAckOnPartialResponse()) {
            this.getReliableEndpoint().getProxy().acknowledge(seq);
        }
    }

    void processingComplete(Message message) {
        CachedOutputStream saved;
        SequenceType sequenceType = RMContextUtils.retrieveRMProperties(message, false).getSequence();
        if (null == sequenceType) {
            return;
        }
        DestinationSequence seq = this.getSequence(sequenceType.getIdentifier());
        if (null != seq) {
            long mn = sequenceType.getMessageNumber();
            seq.processingComplete(mn);
            seq.purgeAcknowledged(mn);
            seq.removeDeliveringMessageNumber(mn);
            if (seq.isTerminated() && seq.allAcknowledgedMessagesDelivered()) {
                this.removeSequence(seq);
            }
        }
        if ((saved = (CachedOutputStream)message.remove((Object)"org.apache.cxf.ws.rm.content")) != null) {
            saved.releaseTempFileHold();
            try {
                saved.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void releaseDeliveringStatus(Message message) {
        DestinationSequence seq;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        SequenceType sequenceType = rmps.getSequence();
        if (null != sequenceType && null != (seq = this.getSequence(sequenceType.getIdentifier()))) {
            seq.removeDeliveringMessageNumber(sequenceType.getMessageNumber());
        }
    }

    private static Message createMessage(Exchange exchange) {
        Endpoint ep = exchange.getEndpoint();
        MessageImpl msg = null;
        if (ep != null) {
            msg = new MessageImpl();
            msg.setExchange(exchange);
            msg = ep.getBinding().createMessage((Message)msg);
        }
        return msg;
    }
}

