/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public final class RoleInfo {
    private final String name;
    private final boolean send;
    private final boolean consume;
    private final boolean createDurableQueue;
    private final boolean deleteDurableQueue;
    private final boolean createNonDurableQueue;
    private final boolean deleteNonDurableQueue;
    private final boolean manage;
    private final boolean browse;

    public static RoleInfo[] from(String jsonString) throws Exception {
        JsonArray array = JsonUtil.readJsonArray(jsonString);
        RoleInfo[] roles = new RoleInfo[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            RoleInfo role;
            JsonObject r = array.getJsonObject(i);
            roles[i] = role = new RoleInfo(r.getString("name"), r.getBoolean("send"), r.getBoolean("consume"), r.getBoolean("createDurableQueue"), r.getBoolean("deleteDurableQueue"), r.getBoolean("createNonDurableQueue"), r.getBoolean("deleteNonDurableQueue"), r.getBoolean("manage"), r.getBoolean("browse"));
        }
        return roles;
    }

    private RoleInfo(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse) {
        this.name = name;
        this.send = send;
        this.consume = consume;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
        this.browse = browse;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public boolean isManage() {
        return this.manage;
    }

    public boolean isBrowse() {
        return this.browse;
    }
}

