/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import javax.servlet.ServletContext;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.session.ActiveSessionStatistics;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionExpirationListener;

public class DistributableSessionManagerFactory
implements io.undertow.servlet.api.SessionManagerFactory {
    private final SessionManagerFactory<Batch> factory;

    public DistributableSessionManagerFactory(SessionManagerFactory<Batch> factory) {
        this.factory = factory;
    }

    public SessionManager createSessionManager(final Deployment deployment) {
        DeploymentInfo info = deployment.getDeploymentInfo();
        boolean statisticsEnabled = info.getMetricsCollector() != null;
        final RecordableInactiveSessionStatistics inactiveSessionStatistics = statisticsEnabled ? new RecordableInactiveSessionStatistics() : null;
        final IdentifierFactoryAdapter factory = new IdentifierFactoryAdapter(info.getSessionIdGenerator());
        final LocalSessionContextFactory localContextFactory = new LocalSessionContextFactory();
        SessionListeners listeners = new SessionListeners();
        final UndertowSessionExpirationListener expirationListener = new UndertowSessionExpirationListener(deployment, listeners);
        SessionManagerConfiguration<LocalSessionContext> configuration = new SessionManagerConfiguration<LocalSessionContext>(){

            public ServletContext getServletContext() {
                return deployment.getServletContext();
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            public SessionExpirationListener getExpirationListener() {
                return expirationListener;
            }

            public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
                return localContextFactory;
            }

            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return inactiveSessionStatistics;
            }
        };
        org.wildfly.clustering.web.session.SessionManager manager = this.factory.createSessionManager((SessionManagerConfiguration)configuration);
        final Batcher batcher = manager.getBatcher();
        info.addThreadSetupAction(new ThreadSetupHandler(){

            public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
                return new ThreadSetupHandler.Action<T, C>(){

                    public T call(HttpServerExchange exchange, C context) throws Exception {
                        Batch batch = batcher.suspendBatch();
                        try (BatchContext ctx = batcher.resumeBatch(batch);){
                            Object object = action.call(exchange, context);
                            return object;
                        }
                    }
                };
            }
        });
        DistributableSessionManagerStatistics statistics = inactiveSessionStatistics != null ? new DistributableSessionManagerStatistics((ActiveSessionStatistics)manager, inactiveSessionStatistics) : null;
        return new DistributableSessionManager(info.getDeploymentName(), (org.wildfly.clustering.web.session.SessionManager<LocalSessionContext, Batch>)manager, listeners, statistics);
    }
}

