/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.audit.SyslogCredentialReferenceSupplier;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.audit.SyslogAuditLogProtocolResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class SyslogAuditLogHandlerService
implements Service<SyslogAuditLogHandlerService>,
SyslogCredentialReferenceSupplier {
    public static final ServiceName SYSLOG_AUDIT_HANDLER = ServiceName.of((String[])new String[]{"org", "wildfly", "management", "audit", "syslog-handler"});
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> tlsClientCertStoreCredentialSourceSupplier = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> tlsClientCertStoreKeyCredentialSourceSupplier = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> tlsTrustStoreSupplier = new InjectedValue();

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public SyslogAuditLogHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsClientCertStoreSupplier() {
        return (ExceptionSupplier)this.tlsClientCertStoreCredentialSourceSupplier.getOptionalValue();
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsClientCertStoreKeySupplier() {
        return (ExceptionSupplier)this.tlsClientCertStoreKeyCredentialSourceSupplier.getOptionalValue();
    }

    public ExceptionSupplier<CredentialSource, Exception> getTlsTrustStoreSupplier() {
        return (ExceptionSupplier)this.tlsTrustStoreSupplier.getOptionalValue();
    }

    public static final SyslogAuditLogHandlerService installService(OperationContext context, ServiceName serviceName, Resource handlerResource) throws OperationFailedException {
        SyslogAuditLogHandlerService service = new SyslogAuditLogHandlerService();
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)service);
        Set protocols = handlerResource.getChildren("protocol");
        if (protocols.isEmpty()) {
            throw DomainManagementLogger.ROOT_LOGGER.noSyslogProtocol();
        }
        Resource.ResourceEntry protocol = (Resource.ResourceEntry)protocols.iterator().next();
        SyslogAuditLogHandler.Transport transport = SyslogAuditLogHandler.Transport.valueOf((String)protocol.getPathElement().getValue().toUpperCase(Locale.ENGLISH));
        if (transport == SyslogAuditLogHandler.Transport.TLS) {
            Set tlsStores = protocol.getChildren("authentication");
            for (Resource.ResourceEntry storeEntry : tlsStores) {
                ModelNode storeModel = storeEntry.getModel();
                String type = storeEntry.getPathElement().getValue();
                if (type.equals("client-certificate-store")) {
                    if (storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD_CREDENTIAL_REFERENCE.getName())) {
                        service.tlsClientCertStoreKeyCredentialSourceSupplier.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder));
                    }
                    if (!storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName())) continue;
                    service.tlsClientCertStoreCredentialSourceSupplier.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder));
                    continue;
                }
                if (!type.equals("truststore") || !storeModel.hasDefined(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE.getName())) continue;
                service.tlsTrustStoreSupplier.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD_CREDENTIAL_REFERENCE, (ModelNode)storeModel, (ServiceBuilder)serviceBuilder));
            }
        }
        serviceBuilder.install();
        return service;
    }
}

