/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.ejb.infinispan.SessionIDSerializer;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.marshalling.Externalizer;

public class InfinispanBeanEntryExternalizer
implements Externalizer<InfinispanBeanEntry<SessionID>> {
    public void writeObject(ObjectOutput output, InfinispanBeanEntry<SessionID> entry) throws IOException {
        output.writeUTF(entry.getBeanName());
        SessionIDSerializer.INSTANCE.write((DataOutput)output, entry.getGroupId());
        Date lastAccessedTime = entry.getLastAccessedTime();
        output.writeLong(lastAccessedTime != null ? lastAccessedTime.getTime() : 0L);
    }

    public InfinispanBeanEntry<SessionID> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InfinispanBeanEntry<SessionID> entry = new InfinispanBeanEntry<SessionID>(input.readUTF(), SessionIDSerializer.INSTANCE.read(input));
        long time = input.readLong();
        if (time > 0L) {
            entry.setLastAccessedTime(new Date(time));
        }
        return entry;
    }

    public Class<InfinispanBeanEntry<SessionID>> getTargetClass() {
        return InfinispanBeanEntry.class;
    }
}

