/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.util._private.Arrays2;

class UserPasswordPasswordUtil {
    private UserPasswordPasswordUtil() {
    }

    public static Password parseUserPassword(byte[] userPassword) throws InvalidKeySpecException {
        Assert.checkNotNullParam((String)"userPassword", (Object)userPassword);
        if (userPassword.length == 0) {
            throw ElytronMessages.log.emptyParameter("userPassword");
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 83, 72, 65}, userPassword)) {
            if (UserPasswordPasswordUtil.prefixEqual(4, new byte[]{125}, userPassword)) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-1", 5, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(4, new byte[]{50, 53, 54, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-256", 8, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(4, new byte[]{51, 56, 52, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-384", 8, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(4, new byte[]{53, 49, 50, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-sha-512", 8, userPassword);
            }
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 83, 83, 72, 65}, userPassword)) {
            if (UserPasswordPasswordUtil.prefixEqual(5, new byte[]{125}, userPassword)) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-1", 6, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(5, new byte[]{50, 53, 54, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-256", 9, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(5, new byte[]{51, 56, 52, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-384", 9, userPassword);
            }
            if (UserPasswordPasswordUtil.prefixEqual(5, new byte[]{53, 49, 50, 125}, userPassword)) {
                return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-sha-512", 9, userPassword);
            }
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 67, 82, 89, 80, 84, 125}, userPassword)) {
            if (userPassword[7] == 95) {
                return UserPasswordPasswordUtil.createBsdCryptBasedPassword(userPassword);
            }
            return UserPasswordPasswordUtil.createCryptBasedPassword(userPassword);
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 77, 68, 53, 125}, userPassword)) {
            return UserPasswordPasswordUtil.createSimpleDigestPassword("simple-digest-md5", 5, userPassword);
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 83, 77, 68, 53, 125}, userPassword)) {
            return UserPasswordPasswordUtil.createSaltedSimpleDigestPassword("password-salt-digest-md5", 6, userPassword);
        }
        if (UserPasswordPasswordUtil.prefixEqual(0, new byte[]{123, 67, 76, 69, 65, 82, 125}, userPassword)) {
            return UserPasswordPasswordUtil.createClearPassword(7, userPassword);
        }
        if (userPassword[0] == 123 && Arrays2.indexOf(userPassword, 125) > 0) {
            throw ElytronMessages.log.unknownLdapPasswordScheme();
        }
        return UserPasswordPasswordUtil.createClearPassword(0, userPassword);
    }

    private static byte upper(byte character) {
        return (byte)(character >= 97 && character <= 122 ? character - 97 + 65 : character);
    }

    private static boolean prefixEqual(int skip, byte[] pattern, byte[] array) {
        if (skip + pattern.length > array.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (UserPasswordPasswordUtil.upper(array[i + skip]) == pattern[i]) continue;
            return false;
        }
        return true;
    }

    private static Password createClearPassword(int skip, byte[] userPassword) {
        if (skip != 0) {
            userPassword = Arrays.copyOfRange(userPassword, skip, userPassword.length);
        }
        return ClearPassword.createRaw("clear", new String(userPassword, StandardCharsets.UTF_8).toCharArray());
    }

    private static Password createSimpleDigestPassword(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int length = userPassword.length - prefixSize;
        byte[] digest = CodePointIterator.ofUtf8Bytes((byte[])userPassword, (int)prefixSize, (int)length).base64Decode().drain();
        return SimpleDigestPassword.createRaw(algorithm, digest);
    }

    private static Password createSaltedSimpleDigestPassword(String algorithm, int prefixSize, byte[] userPassword) throws InvalidKeySpecException {
        int digestLength;
        int length = userPassword.length - prefixSize;
        byte[] decoded = CodePointIterator.ofUtf8Bytes((byte[])userPassword, (int)prefixSize, (int)length).base64Decode().drain();
        int saltLength = decoded.length - (digestLength = UserPasswordPasswordUtil.expectedDigestLengthBytes(algorithm));
        if (saltLength < 1) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        byte[] digest = new byte[digestLength];
        byte[] salt = new byte[saltLength];
        System.arraycopy(decoded, 0, digest, 0, digestLength);
        System.arraycopy(decoded, digestLength, salt, 0, saltLength);
        return SaltedSimpleDigestPassword.createRaw(algorithm, digest, salt);
    }

    private static Password createCryptBasedPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 20) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        int lo = ModularCrypt.MOD_CRYPT.decode(userPassword[7] & 0xFF);
        int hi = ModularCrypt.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        if (lo == -1 || hi == -1) {
            throw ElytronMessages.log.invalidSalt((char)lo, (char)hi);
        }
        short salt = (short)(lo | hi << 6);
        byte[] hash = CodePointIterator.ofUtf8Bytes((byte[])userPassword, (int)9, (int)11).base64Decode(ModularCrypt.MOD_CRYPT, false).drain();
        return UnixDESCryptPassword.createRaw("crypt-des", salt, hash);
    }

    private static Password createBsdCryptBasedPassword(byte[] userPassword) throws InvalidKeySpecException {
        if (userPassword.length != 27) {
            throw ElytronMessages.log.insufficientDataToFormDigestAndSalt();
        }
        int b0 = ModularCrypt.MOD_CRYPT.decode(userPassword[8] & 0xFF);
        int b1 = ModularCrypt.MOD_CRYPT.decode(userPassword[9] & 0xFF);
        int b2 = ModularCrypt.MOD_CRYPT.decode(userPassword[10] & 0xFF);
        int b3 = ModularCrypt.MOD_CRYPT.decode(userPassword[11] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw ElytronMessages.log.invalidRounds((char)b0, (char)b1, (char)b2, (char)b3);
        }
        int iterationCount = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        b0 = ModularCrypt.MOD_CRYPT.decode(userPassword[12] & 0xFF);
        b1 = ModularCrypt.MOD_CRYPT.decode(userPassword[13] & 0xFF);
        b2 = ModularCrypt.MOD_CRYPT.decode(userPassword[14] & 0xFF);
        b3 = ModularCrypt.MOD_CRYPT.decode(userPassword[15] & 0xFF);
        if (b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1) {
            throw ElytronMessages.log.invalidSalt((char)b0, (char)b1, (char)b2, (char)b3);
        }
        int salt = b0 | b1 << 6 | b2 << 12 | b3 << 18;
        byte[] hash = CodePointIterator.ofUtf8Bytes((byte[])userPassword, (int)16, (int)11).base64Decode(ModularCrypt.MOD_CRYPT, false).drain();
        return BSDUnixDESCryptPassword.createRaw("bsd-crypt-des", hash, salt, iterationCount);
    }

    private static int expectedDigestLengthBytes(String algorithm) {
        switch (algorithm) {
            case "password-salt-digest-md5": {
                return 16;
            }
            case "password-salt-digest-sha-1": {
                return 20;
            }
            case "password-salt-digest-sha-256": {
                return 32;
            }
            case "password-salt-digest-sha-384": {
                return 48;
            }
            case "password-salt-digest-sha-512": {
                return 64;
            }
        }
        throw ElytronMessages.log.unrecognizedAlgorithm(algorithm);
    }

    public static byte[] composeUserPassword(Password password) throws IOException {
        String algorithm = password.getAlgorithm();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if ("simple-digest-md5".equals(algorithm)) {
            out.write(new byte[]{123, 109, 100, 53, 125});
            out.write(ByteIterator.ofBytes((byte[])((SimpleDigestPassword)password).getDigest()).base64Encode().asUtf8().drain());
        } else if ("simple-digest-sha-1".equals(algorithm)) {
            out.write(new byte[]{123, 115, 104, 97, 125});
            out.write(ByteIterator.ofBytes((byte[])((SimpleDigestPassword)password).getDigest()).base64Encode().asUtf8().drain());
        } else if ("simple-digest-sha-256".equals(algorithm)) {
            out.write(new byte[]{123, 115, 104, 97, 50, 53, 54, 125});
            out.write(ByteIterator.ofBytes((byte[])((SimpleDigestPassword)password).getDigest()).base64Encode().asUtf8().drain());
        } else if ("simple-digest-sha-384".equals(algorithm)) {
            out.write(new byte[]{123, 115, 104, 97, 51, 56, 52, 125});
            out.write(ByteIterator.ofBytes((byte[])((SimpleDigestPassword)password).getDigest()).base64Encode().asUtf8().drain());
        } else if ("simple-digest-sha-512".equals(algorithm)) {
            out.write(new byte[]{123, 115, 104, 97, 53, 49, 50, 125});
            out.write(ByteIterator.ofBytes((byte[])((SimpleDigestPassword)password).getDigest()).base64Encode().asUtf8().drain());
        } else if ("password-salt-digest-md5".equals(algorithm)) {
            out.write(new byte[]{123, 115, 109, 100, 53, 125});
            out.write(UserPasswordPasswordUtil.composeDigestSalt((SaltedSimpleDigestPassword)password));
        } else if ("password-salt-digest-sha-1".equals(algorithm)) {
            out.write(new byte[]{123, 115, 115, 104, 97, 125});
            out.write(UserPasswordPasswordUtil.composeDigestSalt((SaltedSimpleDigestPassword)password));
        } else if ("password-salt-digest-sha-256".equals(algorithm)) {
            out.write(new byte[]{123, 115, 115, 104, 97, 50, 53, 54, 125});
            out.write(UserPasswordPasswordUtil.composeDigestSalt((SaltedSimpleDigestPassword)password));
        } else if ("password-salt-digest-sha-384".equals(algorithm)) {
            out.write(new byte[]{123, 115, 115, 104, 97, 51, 56, 52, 125});
            out.write(UserPasswordPasswordUtil.composeDigestSalt((SaltedSimpleDigestPassword)password));
        } else if ("password-salt-digest-sha-512".equals(algorithm)) {
            out.write(new byte[]{123, 115, 115, 104, 97, 53, 49, 50, 125});
            out.write(UserPasswordPasswordUtil.composeDigestSalt((SaltedSimpleDigestPassword)password));
        } else if ("bsd-crypt-des".equals(algorithm)) {
            out.write(new byte[]{123, 99, 114, 121, 112, 116, 125, 95});
            UserPasswordPasswordUtil.composeBsdCryptBasedPassword(out, (BSDUnixDESCryptPassword)password);
        } else if ("crypt-des".equals(algorithm)) {
            out.write(new byte[]{123, 99, 114, 121, 112, 116, 125});
            UserPasswordPasswordUtil.composeCryptBasedPassword(out, (UnixDESCryptPassword)password);
        } else {
            if ("clear".equals(algorithm)) {
                return CodePointIterator.ofChars((char[])((ClearPassword)password).getPassword()).asUtf8().drain();
            }
            return null;
        }
        return out.toByteArray();
    }

    private static byte[] composeDigestSalt(SaltedSimpleDigestPassword password) {
        return ByteIterator.ofBytes((byte[])new ByteStringBuilder().append(password.getDigest()).append(password.getSalt()).toArray()).base64Encode().asUtf8().drain();
    }

    private static void composeCryptBasedPassword(ByteArrayOutputStream out, UnixDESCryptPassword password) throws IOException {
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() >> 6 & 0x3F));
        out.write(ByteIterator.ofBytes((byte[])password.getHash()).base64Encode(ModularCrypt.MOD_CRYPT, false).asUtf8().drain());
    }

    private static void composeBsdCryptBasedPassword(ByteArrayOutputStream out, BSDUnixDESCryptPassword password) throws IOException {
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getIterationCount() & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getIterationCount() >> 6 & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getIterationCount() >> 12 & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getIterationCount() >> 18 & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() >> 6 & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() >> 12 & 0x3F));
        out.write(ModularCrypt.MOD_CRYPT.encode(password.getSalt() >> 18 & 0x3F));
        out.write(ByteIterator.ofBytes((byte[])password.getHash()).base64Encode(ModularCrypt.MOD_CRYPT, false).asUtf8().drain());
    }

    public static boolean isAlgorithmSupported(String algorithm) {
        switch (algorithm) {
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": 
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "bsd-crypt-des": 
            case "crypt-des": 
            case "clear": {
                return true;
            }
        }
        return false;
    }
}

