/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.spi.ClusteringDefaultRequirement;
import org.wildfly.extension.messaging.activemq.AddIfAbsentStepHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;

public class DiscoveryGroupAdd
extends AbstractAddStepHandler {
    public static final DiscoveryGroupAdd INSTANCE = new DiscoveryGroupAdd();

    private DiscoveryGroupAdd() {
        super(DiscoveryGroupDefinition.ATTRIBUTES);
    }

    private static boolean isSubsystemResource(OperationContext context) {
        return "subsystem".equals(context.getCurrentAddress().getParent().getLastElement().getKey());
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (operation.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && operation.hasDefined(DiscoveryGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()) && !operation.hasDefined(DiscoveryGroupDefinition.JGROUPS_CHANNEL.getName())) {
            String channel = operation.get(CommonAttributes.JGROUPS_CLUSTER.getName()).asString();
            operation.get(DiscoveryGroupDefinition.JGROUPS_CHANNEL.getName()).set(channel);
            PathAddress channelAddress = DiscoveryGroupAdd.isSubsystemResource(context) ? context.getCurrentAddress().getParent().getParent().append("subsystem", "jgroups").append("channel", channel) : context.getCurrentAddress().getParent().getParent().getParent().append("subsystem", "jgroups").append("channel", channel);
            ModelNode addChannelOperation = Util.createAddOperation((PathAddress)channelAddress);
            addChannelOperation.get("stack").set(operation.get(DiscoveryGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()));
            context.addStep(addChannelOperation, (OperationStepHandler)AddIfAbsentStepHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
        super.execute(context, operation);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        context.registerCapability(DiscoveryGroupDefinition.CAPABILITY.fromBaseCapability(address));
        ModelNode model = resource.getModel();
        if (CommonAttributes.JGROUPS_CLUSTER.resolveModelAttribute(context, model).isDefined() && !DiscoveryGroupDefinition.JGROUPS_CHANNEL.resolveModelAttribute(context, model).isDefined()) {
            context.registerAdditionalCapabilityRequirement(ClusteringDefaultRequirement.COMMAND_DISPATCHER_FACTORY.getName(), DiscoveryGroupDefinition.CAPABILITY.getDynamicName(address), DiscoveryGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceController service;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController serviceController = service = serviceName == null ? null : registry.getService(serviceName);
        if (service != null) {
            context.reloadRequired();
        } else {
            ServiceTarget target = context.getServiceTarget();
            if (!model.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && model.hasDefined(RemoteTransportDefinition.SOCKET_BINDING.getName())) {
                if (serviceName == null) {
                    serviceName = MessagingServices.getActiveMQServiceName((String)null);
                }
                GroupBindingService bindingService = new GroupBindingService();
                target.addService(GroupBindingService.getDiscoveryBaseServiceName(serviceName).append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
            }
        }
    }

    static void addDiscoveryGroupConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("discovery-group")) {
            HashMap<String, DiscoveryGroupConfiguration> configs = configuration.getDiscoveryGroupConfigurations();
            if (configs == null) {
                configs = new HashMap<String, DiscoveryGroupConfiguration>();
                configuration.setDiscoveryGroupConfigurations(configs);
            }
            for (Property prop : model.get("discovery-group").asPropertyList()) {
                configs.put(prop.getName(), DiscoveryGroupAdd.createDiscoveryGroupConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
    }

    public static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int groupPort = socketBinding.getMulticastPort();
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        UDPBroadcastEndpointFactory endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(-1);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }

    public static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, CommandDispatcherFactory commandDispatcherFactory, String channelName) throws Exception {
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        CommandDispatcherBroadcastEndpointFactory endpointFactory = new CommandDispatcherBroadcastEndpointFactory(commandDispatcherFactory, channelName);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

