/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Option;
import java.io.File;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.cli.commands.user.FileBasedSecStoreConfig;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModule;

public abstract class UserAction
extends InputAbstract {
    @Option(name={"--role"}, description="user's role(s), comma separated")
    String role;
    @Option(name={"--user"}, description="The user name (Default: input)")
    String username = null;
    @Option(name={"--entry"}, description="The appConfigurationEntry (default: activemq)")
    String entry = "activemq";

    void checkInputUser() {
        if (this.username == null) {
            this.username = this.input("--user", "Please provider the userName:", null);
        }
    }

    void checkInputRole() {
        if (this.role == null) {
            this.role = this.input("--role", "type a comma separated list of roles", null);
        }
    }

    FileBasedSecStoreConfig getConfiguration() throws Exception {
        AppConfigurationEntry[] entries;
        Configuration securityConfig = Configuration.getConfiguration();
        for (AppConfigurationEntry entry : entries = securityConfig.getAppConfigurationEntry(this.entry)) {
            if (!entry.getLoginModuleName().equals(PropertiesLoginModule.class.getName())) continue;
            String userFileName = (String)entry.getOptions().get("org.apache.activemq.jaas.properties.user");
            String roleFileName = (String)entry.getOptions().get("org.apache.activemq.jaas.properties.role");
            File etcDir = new File(this.getBrokerEtc());
            File userFile = new File(etcDir, userFileName);
            File roleFile = new File(etcDir, roleFileName);
            if (!userFile.exists() || !roleFile.exists()) {
                throw new IllegalArgumentException("Couldn't find user file or role file!");
            }
            return new FileBasedSecStoreConfig(userFile, roleFile);
        }
        throw new IllegalArgumentException("Failed to load security file");
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

