/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.infinispan.Version;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalStateManagerImpl
implements GlobalStateManager {
    public static final String VERSION = "@version";
    public static final String TIMESTAMP = "@timestamp";
    public static final String VERSION_MAJOR = "version-major";
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    private GlobalConfiguration globalConfiguration;
    @Inject
    private TimeService timeService;
    private List<GlobalStateProvider> stateProviders = new ArrayList<GlobalStateProvider>();
    private boolean persistentState;
    FileOutputStream globalLockFile;
    private FileLock globalLock;
    private ScopedPersistentState globalState;

    @Start(priority=1)
    public void start() {
        this.persistentState = this.globalConfiguration.globalState().enabled();
        if (this.persistentState) {
            this.acquireGlobalLock();
            this.loadGlobalState();
        }
    }

    @Stop(priority=1)
    public void stop() {
        if (this.persistentState) {
            this.writeGlobalState();
            this.releaseGlobalLock();
        }
    }

    private void acquireGlobalLock() {
        File lockFile = this.getLockFile();
        try {
            lockFile.getParentFile().mkdirs();
            this.globalLockFile = new FileOutputStream(lockFile);
            this.globalLock = this.globalLockFile.getChannel().tryLock();
            if (this.globalLock == null) {
                throw log.globalStateCannotAcquireLockFile(null, lockFile);
            }
        }
        catch (IOException | OverlappingFileLockException e) {
            throw log.globalStateCannotAcquireLockFile(e, lockFile);
        }
    }

    private void releaseGlobalLock() {
        if (this.globalLock != null && this.globalLock.isValid()) {
            Util.close((AutoCloseable)this.globalLock);
        }
        this.globalLock = null;
        Util.close((AutoCloseable)this.globalLockFile);
        this.getLockFile().delete();
    }

    private void loadGlobalState() {
        File stateFile = this.getStateFile("___global");
        this.globalState = this.readScopedState("___global").orElse(null);
        if (this.globalState != null) {
            ScopedPersistentState state = this.globalState;
            if (!stateFile.canWrite()) {
                throw log.nonWritableStateFile(stateFile);
            }
            if (!(state.containsProperty(VERSION) && state.containsProperty(VERSION_MAJOR) && state.containsProperty(TIMESTAMP))) {
                throw log.invalidPersistentState("___global");
            }
            log.globalStateLoad(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
            this.stateProviders.forEach(provider -> provider.prepareForRestore(state));
        } else {
            stateFile.getParentFile().mkdirs();
        }
    }

    @Override
    public void writeGlobalState() {
        if (this.persistentState) {
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl("___global");
            state.setProperty(VERSION, Version.getVersion());
            state.setProperty(VERSION_MAJOR, Version.getMajor());
            state.setProperty(TIMESTAMP, this.timeService.instant().toString());
            this.stateProviders.forEach(provider -> provider.prepareForPersist(state));
            this.writeScopedState(state);
            log.globalStateWrite(state.getProperty(VERSION), state.getProperty(TIMESTAMP));
        }
    }

    @Override
    public void writeScopedState(ScopedPersistentState state) {
        if (this.persistentState) {
            File stateFile = this.getStateFile(state.getScope());
            try (PrintWriter w = new PrintWriter(stateFile);){
                state.forEach((key, value) -> w.printf("%s=%s%n", Util.unicodeEscapeString((String)key), Util.unicodeEscapeString((String)value)));
            }
            catch (IOException e) {
                throw log.failedWritingGlobalState(e, stateFile);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ScopedPersistentState> readScopedState(String scope) {
        if (!this.persistentState) {
            return Optional.empty();
        }
        File stateFile = this.getStateFile(scope);
        if (!stateFile.exists()) {
            return Optional.empty();
        }
        try (BufferedReader r = new BufferedReader(new FileReader(stateFile));){
            ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(scope);
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    int eq = line.indexOf(61);
                    while (eq > 0 && line.charAt(eq - 1) == '\\') {
                        eq = line.indexOf(61, eq + 1);
                    }
                    if (eq > 0) {
                        state.setProperty(Util.unicodeUnescapeString((String)line.substring(0, eq).trim()), Util.unicodeUnescapeString((String)line.substring(eq + 1).trim()));
                    }
                }
                line = r.readLine();
            }
            Optional<ScopedPersistentState> optional = Optional.of(state);
            return optional;
        }
        catch (IOException e) {
            throw log.failedReadingPersistentState(e, stateFile);
        }
    }

    private File getStateFile(String scope) {
        return new File(this.globalConfiguration.globalState().persistentLocation(), scope + ".state");
    }

    private File getLockFile() {
        return new File(this.globalConfiguration.globalState().persistentLocation(), "___global.lck");
    }

    @Override
    public void registerStateProvider(GlobalStateProvider provider) {
        this.stateProviders.add(provider);
        if (this.globalState != null) {
            provider.prepareForRestore(this.globalState);
        }
    }
}

