/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.cli.factory.BrokerFactory;
import org.apache.activemq.artemis.cli.factory.jmx.ManagementFactory;
import org.apache.activemq.artemis.cli.factory.security.SecurityManagerFactory;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.management.ManagementContext;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ReusableLatch;

@Command(name="run", description="runs the broker instance")
public class Run
extends LockAbstract {
    @Option(name={"--allow-kill"}, description="This will allow the server to kill itself. Useful for tests (failover tests for instance)")
    boolean allowKill;
    private static boolean embedded = false;
    public static final ReusableLatch latchRunning = new ReusableLatch(0);
    private ManagementContext managementContext;
    private Broker server;

    public static void setEmbedded(boolean embedded) {
        Run.embedded = true;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            ManagementContextDTO managementDTO = this.getManagementDTO();
            this.managementContext = ManagementFactory.create(managementDTO);
            Artemis.printBanner();
            BrokerDTO broker = this.getBrokerDTO();
            this.addShutdownHook(broker.server.getConfigurationFile().getParentFile());
            ActiveMQSecurityManager security = SecurityManagerFactory.create(broker.security);
            this.server = BrokerFactory.createServer(broker.server, security);
            this.managementContext.start();
            this.server.start();
            this.server.getServer().registerActivateCallback((ActivateCallback)new CleaningActivateCallback(){

                public void deActivate() {
                    try {
                        Run.this.managementContext.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (broker.web != null) {
                broker.components.add(broker.web);
            }
            for (ComponentDTO componentDTO : broker.components) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(componentDTO.componentClassName);
                ExternalComponent component = (ExternalComponent)clazz.newInstance();
                component.configure(componentDTO, this.getBrokerInstance(), this.getBrokerHome());
                component.start();
                this.server.getServer().addExternalComponent((ActiveMQComponent)component);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.stop();
        }
        return new Pair((Object)this.managementContext, (Object)this.server.getServer());
    }

    private void addShutdownHook(File configurationDir) {
        File fileKill;
        latchRunning.countUp();
        final File file = new File(configurationDir, "STOP_ME");
        if (file.exists() && !file.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        if ((fileKill = new File(configurationDir, "KILL_ME")).exists() && !fileKill.delete()) {
            ActiveMQBootstrapLogger.LOGGER.errorDeletingFile(fileKill.getAbsolutePath());
        }
        final Timer timer = new Timer("ActiveMQ Artemis Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Run.this.allowKill && fileKill.exists()) {
                    try {
                        System.err.println("Halting by user request");
                        fileKill.delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Runtime.getRuntime().halt(0);
                }
                if (file.exists()) {
                    try {
                        Run.this.stop();
                        timer.cancel();
                    }
                    finally {
                        System.out.println("Server stopped!");
                        System.out.flush();
                        latchRunning.countDown();
                        if (!embedded) {
                            Runtime.getRuntime().exit(0);
                        }
                    }
                }
            }
        }, 500L, 500L);
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown-hook"){

            @Override
            public void run() {
                Run.this.stop();
            }
        });
    }

    protected void stop() {
        try {
            if (this.server != null) {
                this.server.stop(true);
            }
            if (this.managementContext != null) {
                this.managementContext.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

