/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.cache.retry.RetryingInvoker;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.CancelSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.ScheduleSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.common.function.ExceptionSupplier;

public class PrimaryOwnerScheduler
implements org.wildfly.clustering.web.cache.session.Scheduler {
    private static final Invoker INVOKER = new RetryingInvoker(new Duration[]{Duration.ZERO, Duration.ofMillis(10L), Duration.ofMillis(100L)});
    private final Function<Key<String>, Node> primaryOwnerLocator;
    private final CommandDispatcher<Scheduler> dispatcher;

    public <C extends Marshallability, L> PrimaryOwnerScheduler(CommandDispatcherFactory dispatcherFactory, String name, Scheduler scheduler, Function<Key<String>, Node> primaryOwnerLocator) {
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)name, (Object)scheduler);
        this.primaryOwnerLocator = primaryOwnerLocator;
    }

    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        try {
            this.executeOnPrimaryOwner(sessionId, new ScheduleSchedulerCommand(sessionId, metaData));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToScheduleSession(e, sessionId);
        }
    }

    public void cancel(String sessionId) {
        try {
            this.executeOnPrimaryOwner(sessionId, new CancelSchedulerCommand(sessionId));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToCancelSession(e, sessionId);
        }
    }

    private void executeOnPrimaryOwner(final String sessionId, final Command<Void, Scheduler> command) throws CommandDispatcherException {
        final Function<Key<String>, Node> primaryOwnerLocator = this.primaryOwnerLocator;
        final CommandDispatcher<Scheduler> dispatcher = this.dispatcher;
        ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException> action = new ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException>(){

            public CompletionStage<Void> get() throws CommandDispatcherException {
                Node node = (Node)primaryOwnerLocator.apply(new Key((Object)sessionId));
                return dispatcher.executeOnMember(command, node);
            }
        };
        ((CompletionStage)INVOKER.invoke((ExceptionSupplier)action)).toCompletableFuture().join();
    }

    public void close() {
        this.dispatcher.close();
    }
}

