/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;

public enum XMLElement {
    SINGLETON_POLICIES("singleton-policies"),
    SINGLETON_POLICY(SingletonPolicyResourceDefinition.WILDCARD_PATH),
    NAME_PREFERENCES(ElectionPolicyResourceDefinition.Attribute.NAME_PREFERENCES),
    RANDOM_ELECTION_POLICY("random-election-policy"),
    SIMPLE_ELECTION_POLICY("simple-election-policy"),
    SOCKET_BINDING_PREFERENCES(ElectionPolicyResourceDefinition.Attribute.SOCKET_BINDING_PREFERENCES);

    private final String localName;
    private static final Map<String, XMLElement> map;

    private XMLElement(PathElement path) {
        this(path.getKey());
    }

    private XMLElement(Attribute attribute) {
        this(((AttributeDefinition)attribute.getDefinition()).getXmlName());
    }

    private XMLElement(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    static XMLElement forName(XMLExtendedStreamReader reader) throws XMLStreamException {
        XMLElement element = map.get(reader.getLocalName());
        if (element == null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return element;
    }

    static {
        map = new HashMap<String, XMLElement>();
        for (XMLElement element : XMLElement.values()) {
            map.put(element.getLocalName(), element);
        }
    }
}

