/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.jca;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporterImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.resource.spi.XATerminator;

public class SubordinationManager {
    private static TransactionImporter transactionImporter = null;
    private static XATerminator xaTerminator = null;
    private static TxType txType;

    public static TransactionImporter getTransactionImporter() {
        if (transactionImporter == null) {
            SubordinationManager.initTransactionImporter();
        }
        return transactionImporter;
    }

    public static XATerminator getXATerminator() {
        if (xaTerminator == null) {
            SubordinationManager.initXATerminator();
        }
        return xaTerminator;
    }

    public static TxType getTxType() {
        return txType;
    }

    public static void setTxType(TxType txType) {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("SubordinationManager.setTxType(" + (Object)((Object)txType) + ")"));
        }
        if (SubordinationManager.txType != null && SubordinationManager.txType != txType) {
            throw new IllegalStateException("SubordinationManager can't change txType once it has been set.");
        }
        SubordinationManager.txType = txType;
    }

    private static void initTransactionImporter() {
        if (txType == null) {
            SubordinationManager.setTxType(SubordinationManager.guessTxType());
        }
        if (txType == TxType.JTA) {
            transactionImporter = new TransactionImporterImple();
        } else {
            try {
                Class<?> clazz = Class.forName("com.arjuna.ats.internal.jta.transaction.jts.jca.TransactionImporterImple");
                transactionImporter = (TransactionImporter)clazz.newInstance();
            }
            catch (Exception e) {
                jtaLogger.i18NLogger.error_transaction_arjunacore_jca_SubordinationManager_importerfailure(e);
            }
        }
    }

    private static void initXATerminator() {
        if (txType == null) {
            SubordinationManager.setTxType(SubordinationManager.guessTxType());
        }
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        if (txType == TxType.JTA) {
            xaTerminator = new XATerminatorImple();
        } else {
            try {
                Class<?> clazz = Class.forName("com.arjuna.ats.internal.jta.transaction.jts.jca.XATerminatorImple");
                xaTerminator = (XATerminator)clazz.newInstance();
            }
            catch (Exception e) {
                jtaLogger.i18NLogger.error_transaction_arjunacore_jca_SubordinationManager_terminatorfailure(e);
            }
        }
    }

    private static TxType guessTxType() {
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        if (tm instanceof TransactionManagerImple) {
            return TxType.JTA;
        }
        if (tm.getClass().getName().contains(".jts.") || tm.getClass().getName().contains(".jtax.")) {
            return TxType.JTS;
        }
        return TxType.JTA;
    }

    public static enum TxType {
        JTA,
        JTS;

    }
}

