/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.EnumMap;
import java.util.Map;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;
import org.wildfly.clustering.server.singleton.Lifecycle;

public class ServiceLifecycle
implements Lifecycle {
    private static final Map<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>> modeToggle = new EnumMap<ServiceController.State, Map<ServiceController.Mode, ServiceController.Mode>>(ServiceController.State.class);
    private final ServiceController<?> controller;

    public ServiceLifecycle(ServiceController<?> controller) {
        this.controller = controller;
    }

    @Override
    public void start() {
        this.transition(ServiceController.State.UP);
    }

    @Override
    public void stop() {
        this.transition(ServiceController.State.DOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transition(ServiceController.State targetState) {
        if (this.controller.getState() == targetState) {
            return;
        }
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(this.controller);
        try {
            ServiceController.Mode targetMode = modeToggle.get(targetState).get(this.controller.getMode());
            if (targetMode != null) {
                this.controller.setMode(targetMode);
            }
            monitor.awaitStability();
            if (this.controller.getState() == ServiceController.State.START_FAILED) {
                throw new IllegalStateException((Throwable)this.controller.getStartException());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            monitor.removeController(this.controller);
        }
    }

    static {
        EnumMap<ServiceController.Mode, ServiceController.Mode> map = new EnumMap<ServiceController.Mode, ServiceController.Mode>(ServiceController.Mode.class);
        map.put(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE);
        map.put(ServiceController.Mode.ON_DEMAND, ServiceController.Mode.PASSIVE);
        modeToggle.put(ServiceController.State.UP, map);
        map = new EnumMap(ServiceController.Mode.class);
        map.put(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER);
        map.put(ServiceController.Mode.PASSIVE, ServiceController.Mode.ON_DEMAND);
        modeToggle.put(ServiceController.State.DOWN, map);
    }
}

