/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.transaction.client.ContextTransactionManager;

public class DatabaseTimerPersistence
implements TimerPersistence,
Service<DatabaseTimerPersistence> {
    private final InjectedValue<ManagedReferenceFactory> dataSourceInjectedValue = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();
    private final Map<String, TimerPersistence.TimerChangeListener> changeListeners = Collections.synchronizedMap(new HashMap());
    private final InjectedValue<Timer> timerInjectedValue = new InjectedValue();
    private final Map<String, Set<String>> knownTimerIds = new HashMap<String, Set<String>>();
    private String database;
    private final HashSet<String> databaseDialects = new HashSet();
    private final String partition;
    private final String nodeName;
    private final int refreshInterval;
    private final boolean allowExecution;
    private volatile ManagedReference managedReference;
    private volatile DataSource dataSource;
    private volatile Properties sql;
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private RefreshTask refreshTask;
    private static final String CREATE_TABLE = "create-table";
    private static final String CREATE_TIMER = "create-timer";
    private static final String UPDATE_TIMER = "update-timer";
    private static final String LOAD_ALL_TIMERS = "load-all-timers";
    private static final String LOAD_TIMER = "load-timer";
    private static final String DELETE_TIMER = "delete-timer";
    private static final String UPDATE_RUNNING = "update-running";
    private static final String SCHEDULER_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Pattern MSSQL_PATTERN = Pattern.compile("(sqlserver|microsoft|mssql)");

    public DatabaseTimerPersistence(String database, String partition, String nodeName, int refreshInterval, boolean allowExecution) {
        this.database = database;
        this.partition = partition;
        this.nodeName = nodeName;
        this.refreshInterval = refreshInterval;
        this.allowExecution = allowExecution;
    }

    public void start(StartContext context) throws StartException {
        this.factory = new RiverMarshallerFactory();
        this.configuration = new MarshallingConfiguration();
        this.configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.moduleLoader.getValue())));
        this.managedReference = ((ManagedReferenceFactory)this.dataSourceInjectedValue.getValue()).getReference();
        this.dataSource = (DataSource)this.managedReference.getInstance();
        InputStream stream = DatabaseTimerPersistence.class.getClassLoader().getResourceAsStream("timer-sql.properties");
        this.sql = new Properties();
        try {
            this.sql.load(stream);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        finally {
            DatabaseTimerPersistence.safeClose(stream);
        }
        this.extractDialects();
        this.investigateDialect();
        this.checkDatabase();
        if (this.refreshInterval > 0) {
            this.refreshTask = new RefreshTask();
            ((Timer)this.timerInjectedValue.getValue()).schedule((TimerTask)this.refreshTask, this.refreshInterval, (long)this.refreshInterval);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.knownTimerIds.clear();
        this.managedReference.release();
        this.managedReference = null;
        this.dataSource = null;
    }

    private void extractDialects() {
        for (Object prop : this.sql.keySet()) {
            int dot = ((String)prop).indexOf(46);
            if (dot <= 0) continue;
            this.databaseDialects.add(((String)prop).substring(dot + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void investigateDialect() {
        Connection connection = null;
        if (this.database == null) {
            try {
                connection = this.dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String dbProduct = metaData.getDatabaseProductName();
                this.database = this.identifyDialect(dbProduct);
                if (this.database == null) {
                    EjbLogger.EJB3_TIMER_LOGGER.debug("Attempting to guess on driver name.");
                    this.database = this.identifyDialect(metaData.getDriverName());
                }
            }
            catch (Exception e) {
                EjbLogger.EJB3_TIMER_LOGGER.debug("Unable to read JDBC metadata.", e);
            }
            finally {
                DatabaseTimerPersistence.safeClose(connection);
            }
            if (this.database == null) {
                EjbLogger.EJB3_TIMER_LOGGER.jdbcDatabaseDialectDetectionFailed(this.databaseDialects.toString());
            } else {
                EjbLogger.EJB3_TIMER_LOGGER.debugf("Detect database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'database' attribute in your configuration.  Supported database dialect strings are %s", this.database, this.databaseDialects);
            }
        } else {
            EjbLogger.EJB3_TIMER_LOGGER.debugf("Database dialect '%s' read from configuration, adjusting it to match the final database valid value.", this.database);
            this.database = this.identifyDialect(this.database);
            EjbLogger.EJB3_TIMER_LOGGER.debugf("New Database dialect is '%s'.", this.database);
        }
    }

    private String identifyDialect(String name) {
        String unified = null;
        if (name != null) {
            if (name.toLowerCase().contains("postgres")) {
                unified = "postgresql";
            } else if (name.toLowerCase().contains("mysql")) {
                unified = "mysql";
            } else if (name.toLowerCase().contains("mariadb")) {
                unified = "mariadb";
            } else if (name.toLowerCase().contains("db2")) {
                unified = "db2";
            } else if (name.toLowerCase().contains("hsql") || name.toLowerCase().contains("hypersonic")) {
                unified = "hsql";
            } else if (name.toLowerCase().contains("h2")) {
                unified = "h2";
            } else if (name.toLowerCase().contains("oracle")) {
                unified = "oracle";
            } else if (MSSQL_PATTERN.matcher(name.toLowerCase()).find()) {
                unified = "mssql";
            } else if (name.toLowerCase().contains("jconnect")) {
                unified = "sybase";
            }
        }
        EjbLogger.EJB3_TIMER_LOGGER.debugf("Check dialect for '%s', result is '%s'", name, unified);
        return unified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabase() {
        String loadTimer = this.sql(LOAD_TIMER);
        Connection connection = null;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            if (connection.getTransactionIsolation() < 2) {
                EjbLogger.EJB3_TIMER_LOGGER.wrongTransactionIsolationConfiguredForTimer();
            }
            preparedStatement = connection.prepareStatement(loadTimer);
            preparedStatement.setString(1, "NON-EXISTENT");
            preparedStatement.setString(2, "NON-EXISTENT");
            preparedStatement.setString(3, "NON-EXISTENT");
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            block12: {
                try {
                    if (connection != null) {
                        try {
                            String[] statements;
                            String createTable = this.sql(CREATE_TABLE);
                            for (String sql : statements = createTable.split(";")) {
                                try {
                                    statement = connection.createStatement();
                                    statement.executeUpdate(sql);
                                }
                                finally {
                                    DatabaseTimerPersistence.safeClose(statement);
                                }
                            }
                            break block12;
                        }
                        catch (SQLException e1) {
                            EjbLogger.EJB3_TIMER_LOGGER.couldNotCreateTable(e1);
                            break block12;
                        }
                    }
                    EjbLogger.EJB3_TIMER_LOGGER.couldNotCreateTable(e);
                }
                catch (Throwable throwable) {
                    DatabaseTimerPersistence.safeClose(resultSet);
                    DatabaseTimerPersistence.safeClose(preparedStatement);
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                    throw throwable;
                }
            }
            DatabaseTimerPersistence.safeClose(resultSet);
            DatabaseTimerPersistence.safeClose(preparedStatement);
            DatabaseTimerPersistence.safeClose(statement);
            DatabaseTimerPersistence.safeClose(connection);
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(preparedStatement);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    private String sql(String key) {
        String result;
        if (this.database != null && (result = this.sql.getProperty(key + "." + this.database)) != null) {
            return result;
        }
        return this.sql.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimer(TimerImpl timerEntity) {
        String createTimer = this.sql(CREATE_TIMER);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            DatabaseTimerPersistence databaseTimerPersistence = this;
            synchronized (databaseTimerPersistence) {
                this.knownTimerIds.get(timerEntity.getTimedObjectId()).add(timerEntity.getId());
            }
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(createTimer);
            this.statementParameters(timerEntity, statement);
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseTimerPersistence.safeClose(resultSet);
                DatabaseTimerPersistence.safeClose(statement);
                DatabaseTimerPersistence.safeClose(connection);
                throw throwable;
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistTimer(TimerImpl timerEntity) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block11: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                if (timerEntity.getState() == TimerState.CANCELED || timerEntity.getState() == TimerState.EXPIRED) {
                    String deleteTimer = this.sql(DELETE_TIMER);
                    statement = connection.prepareStatement(deleteTimer);
                    statement.setString(1, timerEntity.getTimedObjectId());
                    statement.setString(2, timerEntity.getId());
                    statement.setString(3, this.partition);
                    statement.execute();
                    DatabaseTimerPersistence databaseTimerPersistence = this;
                    synchronized (databaseTimerPersistence) {
                        this.knownTimerIds.get(timerEntity.getTimedObjectId()).remove(timerEntity.getId());
                        break block11;
                    }
                }
                DatabaseTimerPersistence deleteTimer = this;
                synchronized (deleteTimer) {
                    this.knownTimerIds.get(timerEntity.getTimedObjectId()).add(timerEntity.getId());
                }
                String updateTimer = this.sql(UPDATE_TIMER);
                statement = connection.prepareStatement(updateTimer);
                statement.setTimestamp(1, this.timestamp(timerEntity.getNextExpiration()));
                statement.setTimestamp(2, this.timestamp(timerEntity.getPreviousRun()));
                statement.setString(3, timerEntity.getState().name());
                this.setNodeName(timerEntity.getState(), statement, 4);
                statement.setString(5, timerEntity.getTimedObjectId());
                statement.setString(6, timerEntity.getId());
                statement.setString(7, this.partition);
                statement.setString(8, this.nodeName);
                statement.execute();
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DatabaseTimerPersistence.safeClose(resultSet);
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                    throw throwable;
                }
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean shouldRun(TimerImpl timer, @Deprecated TransactionManager ignored) {
        boolean ee2222222222;
        ContextTransactionManager tm = ContextTransactionManager.getInstance();
        if (!this.allowExecution) {
            return false;
        }
        String loadTimer = this.sql(UPDATE_RUNNING);
        Connection connection = null;
        PreparedStatement statement = null;
        tm.begin();
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(loadTimer);
            statement.setString(1, TimerState.IN_TIMEOUT.name());
            this.setNodeName(TimerState.IN_TIMEOUT, statement, 2);
            statement.setString(3, timer.getId());
            statement.setString(4, TimerState.IN_TIMEOUT.name());
            statement.setString(5, TimerState.RETRY_TIMEOUT.name());
            if (timer.getNextExpiration() == null) {
                statement.setTimestamp(6, null);
            } else {
                statement.setTimestamp(6, this.timestamp(timer.getNextExpiration()));
            }
        }
        catch (SQLException e) {
            try {
                tm.rollback();
            }
            catch (Exception ee2222222222) {
                EjbLogger.EJB3_TIMER_LOGGER.timerUpdateFailedAndRollbackNotPossible(ee2222222222);
            }
            EjbLogger.EJB3_TIMER_LOGGER.exceptionCheckingIfTimerShouldRun(timer, e);
            boolean ee2222222222 = false;
            DatabaseTimerPersistence.safeClose(statement);
            DatabaseTimerPersistence.safeClose(connection);
            return ee2222222222;
        }
        try {
            int affected = statement.executeUpdate();
            tm.commit();
            ee2222222222 = affected == 1;
        }
        catch (IllegalStateException | SecurityException | SQLException | HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            try {
                tm.rollback();
            }
            catch (IllegalStateException | SecurityException | SystemException rbe) {
                EjbLogger.EJB3_TIMER_LOGGER.timerUpdateFailedAndRollbackNotPossible(rbe);
            }
            EjbLogger.EJB3_TIMER_LOGGER.debugf(e, "Timer %s not running due to exception ", timer);
            boolean bl = false;
            DatabaseTimerPersistence.safeClose(statement);
            DatabaseTimerPersistence.safeClose(connection);
            return bl;
        }
        catch (NotSupportedException e2) {
            EjbLogger.EJB3_TIMER_LOGGER.timerNotRunning(e2, timer);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                    throw throwable;
                }
            }
            DatabaseTimerPersistence.safeClose(statement);
            DatabaseTimerPersistence.safeClose(connection);
            return bl;
        }
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
        return ee2222222222;
    }

    @Override
    public synchronized void timerUndeployed(String timedObjectId) {
        this.knownTimerIds.remove(timedObjectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimerImpl> loadActiveTimers(String timedObjectId, TimerServiceImpl timerService) {
        ArrayList<TimerImpl> arrayList;
        String loadTimer = this.sql(LOAD_ALL_TIMERS);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(loadTimer);
            statement.setString(1, timedObjectId);
            statement.setString(2, this.partition);
            resultSet = statement.executeQuery();
            ArrayList<Holder> timers = new ArrayList<Holder>();
            while (resultSet.next()) {
                try {
                    Holder timerImpl = this.timerFromResult(resultSet, timerService);
                    if (timerImpl != null) {
                        timers.add(timerImpl);
                        continue;
                    }
                    String deleteTimer = this.sql(DELETE_TIMER);
                    Iterator deleteStatement = connection.prepareStatement(deleteTimer);
                    Throwable throwable = null;
                    try {
                        deleteStatement.setString(1, resultSet.getString(2));
                        deleteStatement.setString(2, resultSet.getString(1));
                        deleteStatement.setString(3, this.partition);
                        deleteStatement.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (deleteStatement == null) continue;
                        if (throwable != null) {
                            try {
                                deleteStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        deleteStatement.close();
                    }
                }
                catch (Exception e) {
                    EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(resultSet.getString(2), resultSet.getString(1), e);
                }
            }
            DatabaseTimerPersistence e = this;
            synchronized (e) {
                HashSet<String> ids = new HashSet<String>();
                for (Holder timer : timers) {
                    ids.add(timer.timer.getId());
                }
                this.knownTimerIds.put(timedObjectId, ids);
                for (Holder timer : timers) {
                    if (!timer.requiresReset) continue;
                    TimerImpl ret = timer.timer;
                    EjbLogger.DEPLOYMENT_LOGGER.loadedPersistentTimerInTimeout(ret.getId(), ret.getTimedObjectId());
                    if (ret.getNextExpiration() == null) {
                        ret.setTimerState(TimerState.CANCELED);
                        this.persistTimer(ret);
                        continue;
                    }
                    ret.setTimerState(TimerState.ACTIVE);
                    this.persistTimer(ret);
                }
            }
            ArrayList<TimerImpl> ret = new ArrayList<TimerImpl>();
            for (Holder timer : timers) {
                ret.add(timer.timer);
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseTimerPersistence.safeClose(resultSet);
                DatabaseTimerPersistence.safeClose(statement);
                DatabaseTimerPersistence.safeClose(connection);
                throw throwable;
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
        return arrayList;
    }

    @Override
    public Closeable registerChangeListener(final String timedObjectId, TimerPersistence.TimerChangeListener listener) {
        this.changeListeners.put(timedObjectId, listener);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                DatabaseTimerPersistence.this.changeListeners.remove(timedObjectId);
            }
        };
    }

    public DatabaseTimerPersistence getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private Holder timerFromResult(ResultSet resultSet, TimerServiceImpl timerService) throws SQLException {
        boolean calendarTimer = resultSet.getBoolean(24);
        String nodeName = resultSet.getString(25);
        boolean requiresReset = false;
        TimerImpl.Builder builder = null;
        String timerId = resultSet.getString(1);
        if (calendarTimer) {
            CalendarTimer.Builder cb = CalendarTimer.builder();
            builder = cb;
            cb.setScheduleExprSecond(resultSet.getString(10));
            cb.setScheduleExprMinute(resultSet.getString(11));
            cb.setScheduleExprHour(resultSet.getString(12));
            cb.setScheduleExprDayOfWeek(resultSet.getString(13));
            cb.setScheduleExprDayOfMonth(resultSet.getString(14));
            cb.setScheduleExprMonth(resultSet.getString(15));
            cb.setScheduleExprYear(resultSet.getString(16));
            cb.setScheduleExprStartDate(this.stringAsSchedulerDate(resultSet.getString(17), timerId));
            cb.setScheduleExprEndDate(this.stringAsSchedulerDate(resultSet.getString(18), timerId));
            cb.setScheduleExprTimezone(resultSet.getString(19));
            cb.setAutoTimer(resultSet.getBoolean(20));
            String clazz = resultSet.getString(21);
            String methodName = resultSet.getString(22);
            if (methodName != null) {
                String paramString = resultSet.getString(23);
                String[] params = paramString == null || paramString.isEmpty() ? new String[]{} : paramString.split(";");
                Method timeoutMethod = CalendarTimer.getTimeoutMethod(new TimeoutMethod(clazz, methodName, params), ((TimedObjectInvoker)timerService.getTimedObjectInvoker().getValue()).getClassLoader());
                if (timeoutMethod == null) {
                    EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(resultSet.getString(2), resultSet.getString(1), new NoSuchMethodException());
                    return null;
                }
                cb.setTimeoutMethod(timeoutMethod);
            }
        } else {
            builder = TimerImpl.builder();
        }
        builder.setId(timerId);
        builder.setTimedObjectId(resultSet.getString(2));
        builder.setInitialDate(resultSet.getTimestamp(3));
        builder.setRepeatInterval(resultSet.getLong(4));
        builder.setNextDate(resultSet.getTimestamp(5));
        builder.setPreviousRun(resultSet.getTimestamp(6));
        builder.setPrimaryKey(this.deSerialize(resultSet.getString(7)));
        builder.setInfo((Serializable)this.deSerialize(resultSet.getString(8)));
        builder.setTimerState(TimerState.valueOf(resultSet.getString(9)));
        builder.setPersistent(true);
        TimerImpl ret = builder.build(timerService);
        if (nodeName != null && nodeName.equals(this.nodeName) && (ret.getState() == TimerState.IN_TIMEOUT || ret.getState() == TimerState.RETRY_TIMEOUT)) {
            requiresReset = true;
        }
        return new Holder(ret, requiresReset);
    }

    private void statementParameters(TimerImpl timerEntity, PreparedStatement statement) throws SQLException {
        statement.setString(1, timerEntity.getId());
        statement.setString(2, timerEntity.getTimedObjectId());
        statement.setTimestamp(3, this.timestamp(timerEntity.getInitialExpiration()));
        statement.setLong(4, timerEntity.getInterval());
        statement.setTimestamp(5, this.timestamp(timerEntity.getNextExpiration()));
        statement.setTimestamp(6, this.timestamp(timerEntity.getPreviousRun()));
        statement.setString(7, this.serialize((Serializable)timerEntity.getPrimaryKey()));
        statement.setString(8, this.serialize(timerEntity.getTimerInfo()));
        statement.setString(9, timerEntity.getState().name());
        if (timerEntity instanceof CalendarTimer) {
            CalendarTimer c = (CalendarTimer)timerEntity;
            statement.setString(10, c.getScheduleExpression().getSecond());
            statement.setString(11, c.getScheduleExpression().getMinute());
            statement.setString(12, c.getScheduleExpression().getHour());
            statement.setString(13, c.getScheduleExpression().getDayOfWeek());
            statement.setString(14, c.getScheduleExpression().getDayOfMonth());
            statement.setString(15, c.getScheduleExpression().getMonth());
            statement.setString(16, c.getScheduleExpression().getYear());
            statement.setString(17, this.schedulerDateAsString(c.getScheduleExpression().getStart()));
            statement.setString(18, this.schedulerDateAsString(c.getScheduleExpression().getEnd()));
            statement.setString(19, c.getScheduleExpression().getTimezone());
            statement.setBoolean(20, c.isAutoTimer());
            if (c.isAutoTimer()) {
                statement.setString(21, c.getTimeoutMethod().getDeclaringClass().getName());
                statement.setString(22, c.getTimeoutMethod().getName());
                StringBuilder params = new StringBuilder();
                Class<?>[] parameterTypes = c.getTimeoutMethod().getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    params.append(parameterTypes[i].getName());
                    if (i == parameterTypes.length - 1) continue;
                    params.append(";");
                }
                statement.setString(23, params.toString());
            } else {
                statement.setString(21, null);
                statement.setString(22, null);
                statement.setString(23, null);
            }
            statement.setBoolean(24, true);
        } else {
            statement.setString(10, null);
            statement.setString(11, null);
            statement.setString(12, null);
            statement.setString(13, null);
            statement.setString(14, null);
            statement.setString(15, null);
            statement.setString(16, null);
            statement.setTimestamp(17, null);
            statement.setTimestamp(18, null);
            statement.setString(19, null);
            statement.setBoolean(20, false);
            statement.setString(21, null);
            statement.setString(22, null);
            statement.setString(23, null);
            statement.setBoolean(24, false);
        }
        statement.setString(25, this.partition);
        this.setNodeName(timerEntity.getState(), statement, 26);
    }

    private String serialize(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Marshaller marshaller = this.factory.createMarshaller(this.configuration);
            marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
            marshaller.writeObject((Object)serializable);
            marshaller.finish();
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public Object deSerialize(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        try {
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
            unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
            Object ret = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = ret;
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            DatabaseTimerPersistence.safeClose(in);
        }
    }

    private String schedulerDateAsString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(SCHEDULER_DATE_FORMAT).format(date);
    }

    private Date stringAsSchedulerDate(String date, String timerId) {
        if (date == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(SCHEDULER_DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            EjbLogger.EJB3_TIMER_LOGGER.scheduleExpressionDateFromTimerPersistenceInvalid(timerId, e.getMessage());
            return null;
        }
    }

    private Timestamp timestamp(Date date) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        if (this.database != null && this.database.equals("mysql")) {
            time -= time % 1000L;
        }
        return new Timestamp(time);
    }

    private void setNodeName(TimerState timerState, PreparedStatement statement, int paramIndex) throws SQLException {
        if (timerState == TimerState.IN_TIMEOUT || timerState == TimerState.RETRY_TIMEOUT) {
            statement.setString(paramIndex, this.nodeName);
        } else {
            statement.setNull(paramIndex, 12);
        }
    }

    public InjectedValue<ManagedReferenceFactory> getDataSourceInjectedValue() {
        return this.dataSourceInjectedValue;
    }

    public InjectedValue<ModuleLoader> getModuleLoader() {
        return this.moduleLoader;
    }

    public InjectedValue<Timer> getTimerInjectedValue() {
        return this.timerInjectedValue;
    }

    private static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_TIMER_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(Statement resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_TIMER_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(Connection resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_TIMER_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(ResultSet resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_TIMER_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    static final class Holder {
        final TimerImpl timer;
        final boolean requiresReset;

        Holder(TimerImpl timer, boolean requiresReset) {
            this.timer = timer;
            this.requiresReset = requiresReset;
        }

        public TimerImpl getTimer() {
            return this.timer;
        }

        public boolean isRequiresReset() {
            return this.requiresReset;
        }
    }

    private class RefreshTask
    extends TimerTask {
        private volatile AtomicBoolean running = new AtomicBoolean();

        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (!this.running.compareAndSet(false, true)) return;
            try {
                HashSet timedObjects;
                DatabaseTimerPersistence databaseTimerPersistence = DatabaseTimerPersistence.this;
                synchronized (databaseTimerPersistence) {
                    timedObjects = new HashSet(DatabaseTimerPersistence.this.knownTimerIds.keySet());
                }
                for (String timedObjectId : timedObjects) {
                    HashSet existing;
                    TimerPersistence.TimerChangeListener listener = (TimerPersistence.TimerChangeListener)DatabaseTimerPersistence.this.changeListeners.get(timedObjectId);
                    if (listener == null) continue;
                    DatabaseTimerPersistence databaseTimerPersistence2 = DatabaseTimerPersistence.this;
                    synchronized (databaseTimerPersistence2) {
                        existing = new HashSet((Collection)DatabaseTimerPersistence.this.knownTimerIds.get(timedObjectId));
                    }
                    String loadTimer = DatabaseTimerPersistence.this.sql(DatabaseTimerPersistence.LOAD_ALL_TIMERS);
                    Connection connection = null;
                    PreparedStatement statement = null;
                    ResultSet resultSet = null;
                    try {
                        connection = DatabaseTimerPersistence.this.dataSource.getConnection();
                        statement = connection.prepareStatement(loadTimer);
                        statement.setString(1, timedObjectId);
                        statement.setString(2, DatabaseTimerPersistence.this.partition);
                        resultSet = statement.executeQuery();
                        TimerServiceImpl timerService = listener.getTimerService();
                        while (resultSet.next()) {
                            try {
                                Holder holder;
                                String id = resultSet.getString(1);
                                if (!existing.remove(id)) {
                                    DatabaseTimerPersistence databaseTimerPersistence3 = DatabaseTimerPersistence.this;
                                    synchronized (databaseTimerPersistence3) {
                                        ((Set)DatabaseTimerPersistence.this.knownTimerIds.get(timedObjectId)).add(id);
                                    }
                                    holder = DatabaseTimerPersistence.this.timerFromResult(resultSet, timerService);
                                    if (holder == null) continue;
                                    listener.timerAdded(holder.timer);
                                    continue;
                                }
                                holder = DatabaseTimerPersistence.this.timerFromResult(resultSet, listener.getTimerService());
                                if (holder == null) continue;
                                TimerImpl oldTimer = listener.getTimerService().getTimer(id);
                                EnumSet<TimerState> valid = EnumSet.of(TimerState.IN_TIMEOUT, TimerState.RETRY_TIMEOUT, TimerState.CREATED, TimerState.ACTIVE);
                                boolean validDBTimer = valid.contains((Object)holder.timer.getState());
                                boolean validMemoryTimer = !valid.contains((Object)oldTimer.getState());
                                if (!validMemoryTimer || !validDBTimer) continue;
                                DatabaseTimerPersistence databaseTimerPersistence4 = DatabaseTimerPersistence.this;
                                synchronized (databaseTimerPersistence4) {
                                    Set timers = (Set)DatabaseTimerPersistence.this.knownTimerIds.get(timedObjectId);
                                    timers.remove(oldTimer.getId());
                                    listener.timerSync(oldTimer, holder.timer);
                                }
                            }
                            catch (Exception e) {
                                EjbLogger.EJB3_TIMER_LOGGER.timerReinstatementFailed(resultSet.getString(2), resultSet.getString(1), e);
                            }
                        }
                        DatabaseTimerPersistence databaseTimerPersistence5 = DatabaseTimerPersistence.this;
                        synchronized (databaseTimerPersistence5) {
                            Set timers = (Set)DatabaseTimerPersistence.this.knownTimerIds.get(timedObjectId);
                            for (String timer : existing) {
                                TimerImpl timer1 = timerService.getTimer(timer);
                                if (timer1 == null || timer1.getState() == TimerState.CREATED) continue;
                                timers.remove(timer);
                                listener.timerRemoved(timer);
                            }
                        }
                    }
                    catch (SQLException e) {
                        try {
                            EjbLogger.EJB3_TIMER_LOGGER.failedToRefreshTimers(timedObjectId);
                        }
                        catch (Throwable throwable) {
                            DatabaseTimerPersistence.safeClose(resultSet);
                            DatabaseTimerPersistence.safeClose(statement);
                            DatabaseTimerPersistence.safeClose(connection);
                            throw throwable;
                            return;
                        }
                        DatabaseTimerPersistence.safeClose(resultSet);
                        DatabaseTimerPersistence.safeClose(statement);
                        DatabaseTimerPersistence.safeClose(connection);
                        continue;
                    }
                    DatabaseTimerPersistence.safeClose(resultSet);
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                }
            }
            finally {
                this.running.set(false);
            }
        }
    }
}

