/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing.resolver;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.Properties;
import org.jboss.dmr.ModelNode;
import org.wildfly.microprofile.opentracing.smallrye.TracerConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaegerEnvTracerConfiguration
implements TracerConfiguration {
    private static final String JAEGER_ENV_PREFIX = "JAEGER_";

    public Tracer createTracer(String serviceName) {
        return Configuration.fromEnv((String)serviceName).getTracerBuilder().withManualShutdown().build();
    }

    public String getModuleName() {
        return "io.jaegertracing.jaeger";
    }

    public ModelNode getModel() {
        ModelNode model = new ModelNode();
        model.get("class").set("io.jaegertracing.internal.JaegerTracer");
        ModelNode configuration = new ModelNode();
        for (Map.Entry envVariable : WildFlySecurityManager.getSystemEnvironmentPrivileged().entrySet()) {
            if (!((String)envVariable.getKey()).startsWith(JAEGER_ENV_PREFIX)) continue;
            configuration.get((String)envVariable.getKey()).set((String)envVariable.getValue());
        }
        Properties properties = WildFlySecurityManager.getSystemPropertiesPrivileged();
        for (String property : properties.stringPropertyNames()) {
            if (!property.startsWith(JAEGER_ENV_PREFIX)) continue;
            configuration.get(property).set(properties.getProperty(property));
        }
        model.get("configuration").set(configuration);
        return model;
    }

    public String getName() {
        return "org.wildfly.microprofile.opentracing.env-tracer";
    }
}

