/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.jaxrs.DenyAllFilter;
import io.smallrye.jwt.auth.jaxrs.RolesAllowedFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

public class JWTAuthorizationFilterRegistrar
implements DynamicFeature {
    private static final DenyAllFilter denyAllFilter = new DenyAllFilter();
    private final Set<Class<? extends Annotation>> mpJwtAnnotations = new HashSet<Class>(Arrays.asList(DenyAll.class, PermitAll.class, RolesAllowed.class));

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Annotation mpJwtAnnotation = this.getMpJwtAnnotation(resourceInfo);
        if (mpJwtAnnotation != null) {
            if (mpJwtAnnotation instanceof DenyAll) {
                this.configureDenyAll(context);
            } else if (mpJwtAnnotation instanceof RolesAllowed) {
                this.configureRolesAllowed((RolesAllowed)mpJwtAnnotation, context);
            }
        } else if (this.hasSecurityAnnotations(resourceInfo) && this.shouldNonannotatedMethodsBeDenied()) {
            this.configureDenyAll(context);
        }
    }

    private void configureRolesAllowed(RolesAllowed mpJwtAnnotation, FeatureContext context) {
        context.register((Object)new RolesAllowedFilter(mpJwtAnnotation.value()));
    }

    private void configureDenyAll(FeatureContext context) {
        context.register((Object)denyAllFilter);
    }

    private Annotation getMpJwtAnnotation(ResourceInfo resourceInfo) {
        Annotation annotation = this.getAnnotation(resourceInfo.getResourceMethod().getDeclaredAnnotations(), () -> resourceInfo.getResourceClass().getCanonicalName() + ":" + resourceInfo.getResourceMethod().getName());
        if (annotation == null) {
            annotation = this.getAnnotation(resourceInfo.getResourceMethod().getDeclaringClass().getDeclaredAnnotations(), () -> resourceInfo.getResourceClass().getCanonicalName());
        }
        return annotation;
    }

    private Annotation getAnnotation(Annotation[] declaredAnnotations, Supplier<String> annotationPlacementDescriptor) {
        List annotations = Stream.of(declaredAnnotations).filter(annotation -> this.mpJwtAnnotations.contains(annotation.annotationType())).collect(Collectors.toList());
        switch (annotations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Annotation)annotations.iterator().next();
            }
        }
        throw new IllegalStateException("Duplicate MicroProfile JWT annotations found on " + annotationPlacementDescriptor.get() + ". Expected at most 1 annotation, found: " + annotations);
    }

    private boolean hasSecurityAnnotations(ResourceInfo resource) {
        return Stream.of(resource.getResourceClass().getMethods()).filter(this::isResourceMethod).anyMatch(this::hasSecurityAnnotations);
    }

    private boolean hasSecurityAnnotations(Method method) {
        return Stream.of(method.getAnnotations()).anyMatch(annotation -> this.mpJwtAnnotations.contains(annotation.annotationType()));
    }

    private boolean isResourceMethod(Method method) {
        return Stream.of(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getAnnotation(HttpMethod.class) != null);
    }

    private boolean shouldNonannotatedMethodsBeDenied() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource("/META-INF/MP-JWT-DENY-NONANNOTATED-METHODS");
        return resource != null;
    }
}

