/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ParameterProcessor {
    private static final Logger LOG = Logger.getLogger(ParameterProcessor.class);
    private static Comparator<ParameterContextKey> parameterComparator = Comparator.comparing(ParameterContextKey::getLocation, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(ParameterContextKey::getName, Comparator.nullsLast(Comparator.reverseOrder()));
    private static Set<DotName> openApiParameterAnnotations = new HashSet<DotName>(Arrays.asList(OpenApiConstants.DOTNAME_PARAMETER, OpenApiConstants.DOTNAME_PARAMETERS));
    private final IndexView index;
    private final Function<AnnotationInstance, ParameterImpl> reader;
    private final List<AnnotationScannerExtension> extensions;
    private Map<ParameterContextKey, ParameterContext> params = new TreeMap<ParameterContextKey, ParameterContext>(parameterComparator);
    private Map<String, AnnotationInstance> formParams = new LinkedHashMap<String, AnnotationInstance>();
    private String formMediaType;
    private Map<String, Map<String, AnnotationInstance>> matrixParams = new LinkedHashMap<String, Map<String, AnnotationInstance>>();

    private ParameterProcessor(IndexView index, Function<AnnotationInstance, ParameterImpl> reader, List<AnnotationScannerExtension> extensions) {
        this.index = index;
        this.reader = reader;
        this.extensions = extensions;
    }

    public static ResourceParameters process(IndexView index, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, ParameterImpl> reader, List<AnnotationScannerExtension> extensions) {
        ResourceParameters parameters = new ResourceParameters();
        ParameterProcessor processor = new ParameterProcessor(index, reader, extensions);
        ClassInfo resourceMethodClass = resourceMethod.declaringClass();
        processor.readParameters(resourceMethodClass, null);
        if (!resourceClass.equals(resourceMethodClass)) {
            processor.readParameters(resourceClass, null);
        }
        parameters.setPathItemParameters(processor.getParameters());
        parameters.setPathItemPath(processor.generatePath((AnnotationTarget)resourceClass, parameters.getPathItemParameters()));
        processor.reset();
        resourceMethod.annotations().stream().filter(a -> !a.target().equals(resourceMethod)).forEach(annotation -> {
            if (openApiParameterAnnotations.contains(annotation.name())) {
                processor.readParameterAnnotation((AnnotationInstance)annotation);
            } else {
                processor.readAnnotatedType((AnnotationInstance)annotation);
            }
        });
        resourceMethod.annotations().stream().filter(a -> a.target().equals(resourceMethod)).filter(a -> openApiParameterAnnotations.contains(a.name())).forEach(processor::readParameterAnnotation);
        parameters.setOperationParameters(processor.getParameters());
        parameters.setOperationPath(processor.generatePath((AnnotationTarget)resourceMethod, parameters.getOperationParameters()));
        parameters.setFormBodyContent(processor.getFormBodyContent());
        return parameters;
    }

    private void reset() {
        this.params.clear();
        this.formParams.clear();
        this.matrixParams.clear();
    }

    String generatePath(AnnotationTarget target, List<Parameter> parameters) {
        String path = ParameterProcessor.pathOf(target);
        if (path.length() > 0) {
            path = '/' + path;
        }
        if (this.matrixParams.size() > 0) {
            String matrixName = parameters.stream().filter(p -> p.getStyle() == Parameter.Style.MATRIX).map(Parameter::getName).findFirst().orElse("");
            if (matrixName.length() > 0) {
                path = path + '{' + matrixName + '}';
            } else {
                LOG.debugf("Matrix parameter was blank for path %s, target %s", (Object)path, (Object)target.toString());
            }
        }
        return path;
    }

    private List<Parameter> getParameters() {
        ArrayList<ParameterImpl> parameters = new ArrayList<ParameterImpl>();
        if (this.matrixParams.size() > 0) {
            for (Map.Entry entry : this.matrixParams.entrySet()) {
                List<Schema> schemas;
                String contextPath = (String)entry.getKey();
                ParameterContext context = this.params.values().stream().filter(p -> p.oaiParam != null).filter(p -> p.oaiParam.getStyle() == Parameter.Style.MATRIX).filter(p -> contextPath.equals(ParameterProcessor.fullPathOf(p.target))).findFirst().orElse(null);
                if (context == null) {
                    context = new ParameterContext();
                    String finalSegment = contextPath.substring(contextPath.lastIndexOf(47) + 1);
                    if (finalSegment.startsWith("{") && finalSegment.endsWith("}")) {
                        finalSegment = finalSegment.substring(1, finalSegment.length() - 1);
                    }
                    context.name = finalSegment + "Matrix";
                    context.location = Parameter.In.PATH;
                    context.jaxRsParam = JaxRsParameter.MATRIX_PARAM;
                    context.target = null;
                    context.targetType = null;
                    context.oaiParam = new ParameterImpl();
                    context.oaiParam.explode(Boolean.TRUE);
                    this.params.put(new ParameterContextKey(context), context);
                }
                if ((schemas = ModelUtil.getParameterSchemas(context.oaiParam)).isEmpty()) {
                    SchemaImpl schema = new SchemaImpl();
                    schema.setType(Schema.SchemaType.OBJECT);
                    ModelUtil.setParameterSchema(context.oaiParam, schema);
                    schemas = Arrays.asList(schema);
                }
                for (Schema schema : schemas) {
                    this.setSchemaProperties(schema, Collections.emptyMap(), (Map)entry.getValue());
                }
            }
        }
        for (ParameterContext parameterContext : this.params.values()) {
            ParameterImpl param = parameterContext.oaiParam == null ? new ParameterImpl() : parameterContext.oaiParam;
            if (param.getName() == null) {
                param.setName(parameterContext.name);
            }
            if (param.getIn() == null && parameterContext.location != null) {
                param.setIn(parameterContext.location);
            }
            if (ParameterProcessor.isIgnoredParameter(param)) continue;
            if (param.getIn() == Parameter.In.PATH) {
                param.setRequired(true);
            }
            if (param.getStyle() == null && parameterContext.jaxRsParam != null) {
                param.setStyle(parameterContext.jaxRsParam.style);
            }
            if (!ModelUtil.parameterHasSchema(param) && parameterContext.targetType != null) {
                Schema schema = SchemaFactory.typeToSchema(this.index, parameterContext.targetType, this.extensions);
                ModelUtil.setParameterSchema(param, schema);
            }
            if (param.getDeprecated() == null && TypeUtil.hasAnnotation(parameterContext.target, OpenApiConstants.DOTNAME_DEPRECATED)) {
                param.setDeprecated(Boolean.TRUE);
            }
            if (param.getSchema() != null) {
                BeanValidationScanner.applyConstraints(parameterContext.target, param.getSchema(), param.getName(), (target, name) -> {
                    if (param.getRequired() == null) {
                        param.setRequired(Boolean.TRUE);
                    }
                });
                if (param.getSchema().getDefaultValue() == null) {
                    param.getSchema().setDefaultValue(parameterContext.jaxRsDefaultValue);
                }
            }
            if (param.getRequired() == null && TypeUtil.isOptional(parameterContext.targetType)) {
                param.setRequired(Boolean.FALSE);
            }
            parameters.add(param);
        }
        return parameters.isEmpty() ? null : parameters.stream().sorted(Comparator.comparing(Parameter::getIn).thenComparing(Parameter::getName)).collect(Collectors.toList());
    }

    private Content getFormBodyContent() {
        if (this.formParams.isEmpty()) {
            return null;
        }
        ContentImpl content = new ContentImpl();
        MediaTypeImpl mediaType = new MediaTypeImpl();
        SchemaImpl schema = new SchemaImpl();
        HashMap<String, Encoding> encodings = new HashMap<String, Encoding>();
        schema.setType(Schema.SchemaType.OBJECT);
        mediaType.setSchema(schema);
        this.setSchemaProperties(schema, encodings, this.formParams);
        if (encodings.size() > 0) {
            mediaType.setEncoding(encodings);
        }
        String mediaTypeName = this.formMediaType != null ? this.formMediaType : "application/x-www-form-urlencoded";
        content.addMediaType(mediaTypeName, mediaType);
        return content;
    }

    void setSchemaProperties(Schema schema, Map<String, Encoding> encodings, Map<String, AnnotationInstance> params) {
        for (Map.Entry<String, AnnotationInstance> param : params.entrySet()) {
            String paramName = param.getKey();
            AnnotationTarget paramTarget = param.getValue().target();
            ParameterProcessor.addEncoding(encodings, paramName, paramTarget);
            Type paramType = ParameterProcessor.getType(paramTarget);
            Schema paramSchema = SchemaFactory.typeToSchema(this.index, paramType, this.extensions);
            Object defaultValue = ParameterProcessor.getDefaultValue(paramTarget);
            if (paramSchema.getDefaultValue() == null) {
                paramSchema.setDefaultValue(defaultValue);
            }
            BeanValidationScanner.applyConstraints(paramTarget, paramSchema, paramName, (target, name) -> {
                List requiredProperties = schema.getRequired();
                if (requiredProperties == null || !requiredProperties.contains(name)) {
                    schema.addRequired(name);
                }
            });
            if (paramSchema.getNullable() == null && TypeUtil.isOptional(paramType)) {
                paramSchema.setNullable(Boolean.TRUE);
            }
            if (schema.getProperties() != null) {
                paramSchema = MergeUtil.mergeObjects(schema.getProperties().get(paramName), paramSchema);
            }
            schema.addProperty(paramName, paramSchema);
        }
    }

    static void addEncoding(Map<String, Encoding> encodings, String paramName, AnnotationTarget paramTarget) {
        if (paramTarget == null) {
            return;
        }
        AnnotationInstance type = TypeUtil.getAnnotation(paramTarget, OpenApiConstants.DOTNAME_RESTEASY_PART_TYPE);
        if (type != null) {
            EncodingImpl encoding = new EncodingImpl();
            encoding.setContentType(type.value().asString());
            encodings.put(paramName, encoding);
        }
    }

    static boolean isIgnoredParameter(ParameterImpl parameter) {
        String paramName = parameter.getName();
        Parameter.In paramIn = parameter.getIn();
        if (paramIn == null) {
            return true;
        }
        if (parameter.isHidden()) {
            return true;
        }
        if ((paramName == null || paramName.trim().isEmpty()) && parameter.getRef() == null) {
            return true;
        }
        if (paramIn == Parameter.In.HEADER && paramName != null) {
            switch (paramName.toUpperCase()) {
                case "ACCEPT": 
                case "AUTHORIZATION": 
                case "CONTENT-TYPE": {
                    return true;
                }
            }
        }
        return false;
    }

    void readParameterAnnotation(AnnotationInstance annotation) {
        AnnotationValue annotationValue;
        DotName name = annotation.name();
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name)) {
            this.readAnnotatedType(annotation, null);
        } else if (OpenApiConstants.DOTNAME_PARAMETERS.equals((Object)name) && (annotationValue = annotation.value()) != null) {
            for (AnnotationInstance nested : annotationValue.asNestedArray()) {
                this.readAnnotatedType(AnnotationInstance.create((DotName)nested.name(), (AnnotationTarget)annotation.target(), (List)nested.values()), null);
            }
        }
    }

    void readAnnotatedType(AnnotationInstance annotation) {
        this.readAnnotatedType(annotation, null);
    }

    void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation) {
        DotName name = annotation.name();
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name)) {
            ParameterImpl oaiParam = this.reader.apply(annotation);
            this.readParameter(oaiParam.getName(), oaiParam.getIn(), oaiParam, null, null, annotation.target());
        } else {
            JaxRsParameter jaxRsParam = JaxRsParameter.forName(name);
            if (jaxRsParam != null) {
                AnnotationTarget target = annotation.target();
                if (jaxRsParam.style == Parameter.Style.FORM) {
                    this.formParams.put(ParameterProcessor.paramName(annotation), annotation);
                } else if (jaxRsParam.style == Parameter.Style.MATRIX) {
                    String pathSegment;
                    String string = pathSegment = beanParamAnnotation != null ? ParameterProcessor.fullPathOf(beanParamAnnotation.target()) : ParameterProcessor.fullPathOf(target);
                    if (!this.matrixParams.containsKey(pathSegment)) {
                        this.matrixParams.put(pathSegment, new HashMap());
                    }
                    this.matrixParams.get(pathSegment).put(ParameterProcessor.paramName(annotation), annotation);
                } else if (jaxRsParam.location != null) {
                    this.readParameter(ParameterProcessor.paramName(annotation), jaxRsParam.location, null, jaxRsParam, ParameterProcessor.getDefaultValue(target), target);
                } else if (target != null) {
                    this.setMediaType(jaxRsParam);
                    Type targetType = ParameterProcessor.getType(target);
                    if (TypeUtil.isOptional(targetType)) {
                        targetType = TypeUtil.getOptionalType(targetType);
                    }
                    if (targetType != null) {
                        ClassInfo beanParam = this.index.getClassByName(targetType.name());
                        this.readParameters(beanParam, annotation);
                    }
                }
            }
        }
    }

    private void setMediaType(JaxRsParameter jaxRsParam) {
        if (jaxRsParam.mediaType != null && this.formMediaType == null) {
            this.formMediaType = jaxRsParam.mediaType;
        }
    }

    static String paramName(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value();
        String valueString = null;
        if (value != null && (valueString = value.asString()).length() > 0) {
            return valueString;
        }
        AnnotationTarget target = annotation.target();
        switch (target.kind()) {
            case FIELD: {
                valueString = target.asField().name();
                break;
            }
            case METHOD_PARAMETER: {
                valueString = target.asMethodParameter().name();
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                if (method.parameters().size() != 1) break;
                String methodName = method.name();
                if (methodName.startsWith("set")) {
                    valueString = Introspector.decapitalize(methodName.substring(3));
                    break;
                }
                valueString = methodName;
                break;
            }
        }
        return valueString;
    }

    static Object getDefaultValue(AnnotationTarget target) {
        AnnotationInstance defaultValueAnno = TypeUtil.getAnnotation(target, OpenApiConstants.DOTNAME_DEFAULT_VALUE);
        Object defaultValue = null;
        if (defaultValueAnno != null) {
            String defaultValueString = JandexUtil.stringValue(defaultValueAnno, "value");
            defaultValue = defaultValueString;
            Type targetType = ParameterProcessor.getType(target);
            if (targetType != null && targetType.kind() == Type.Kind.PRIMITIVE) {
                PrimitiveType.Primitive primitive = targetType.asPrimitiveType().primitive();
                try {
                    switch (primitive) {
                        case BOOLEAN: {
                            defaultValue = Boolean.parseBoolean(defaultValueString);
                            break;
                        }
                        case CHAR: {
                            if (defaultValueString.length() != 1) break;
                            defaultValue = Character.valueOf(defaultValueString.charAt(0));
                            break;
                        }
                        case BYTE: {
                            byte[] bytes = defaultValueString.getBytes();
                            if (bytes.length != 1) break;
                            defaultValue = bytes[0];
                            break;
                        }
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            defaultValue = Long.valueOf(defaultValueString);
                            break;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            defaultValue = Double.valueOf(defaultValueString);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warnf("Value '%s' is not a valid %s default", (Object)defaultValueString, (Object)primitive.name().toLowerCase());
                }
            }
        }
        return defaultValue;
    }

    static String fullPathOf(AnnotationTarget target) {
        String pathSegment = null;
        switch (target.kind()) {
            case FIELD: {
                pathSegment = ParameterProcessor.pathOf((AnnotationTarget)target.asField().declaringClass());
                break;
            }
            case METHOD: {
                pathSegment = ParameterProcessor.methodPath(target.asMethod());
                break;
            }
            case METHOD_PARAMETER: {
                pathSegment = ParameterProcessor.methodPath(target.asMethodParameter().method());
                break;
            }
        }
        return pathSegment;
    }

    static String methodPath(MethodInfo method) {
        String methodPath = ParameterProcessor.pathOf((AnnotationTarget)method);
        String classPath = ParameterProcessor.pathOf((AnnotationTarget)method.declaringClass());
        if (methodPath.isEmpty()) {
            return classPath;
        }
        return classPath + '/' + methodPath;
    }

    static String pathOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        switch (target.kind()) {
            case CLASS: {
                path = target.asClass().classAnnotation(OpenApiConstants.DOTNAME_PATH);
                break;
            }
            case METHOD: {
                path = target.asMethod().annotation(OpenApiConstants.DOTNAME_PATH);
                break;
            }
        }
        if (path != null) {
            String pathValue = path.value().asString();
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            return pathValue;
        }
        return "";
    }

    static Type getType(AnnotationTarget target) {
        if (target == null) {
            return null;
        }
        Type type = null;
        switch (target.kind()) {
            case FIELD: {
                type = target.asField().type();
                break;
            }
            case METHOD: {
                List methodParams = target.asMethod().parameters();
                if (methodParams.size() != 1) break;
                type = (Type)methodParams.get(0);
                break;
            }
            case METHOD_PARAMETER: {
                type = JandexUtil.getMethodParameterType(target.asMethodParameter());
                break;
            }
        }
        return type;
    }

    void readParameter(String name, Parameter.In location, ParameterImpl oaiParam, JaxRsParameter jaxRsParam, Object jaxRsDefaultValue, AnnotationTarget target) {
        ParameterContext context = this.getParameterContext(name, location, target);
        boolean addParam = false;
        if (context == null) {
            context = new ParameterContext();
            addParam = true;
        }
        if (oaiParam != null && name != null) {
            if (context.name != null) {
                this.params.remove(new ParameterContextKey(context.name, context.location));
                addParam = true;
            }
            context.name = name;
        } else if (context.name == null) {
            context.name = name;
        }
        if (context.location == null) {
            context.location = location;
        }
        context.oaiParam = MergeUtil.mergeObjects(context.oaiParam, oaiParam);
        if (context.jaxRsParam == null) {
            context.jaxRsParam = jaxRsParam;
            context.jaxRsDefaultValue = jaxRsDefaultValue;
        }
        if (context.target == null || context.target.kind() == AnnotationTarget.Kind.METHOD) {
            context.target = target;
            context.targetType = ParameterProcessor.getType(target);
        }
        if (addParam) {
            this.params.put(new ParameterContextKey(name, location), context);
        }
    }

    ParameterContext getParameterContext(String name, Parameter.In location, AnnotationTarget target) {
        ParameterContext context = this.params.get(new ParameterContextKey(name, location));
        if (context == null && target.kind() != AnnotationTarget.Kind.METHOD) {
            context = this.params.values().stream().filter(c -> target.equals(c.target)).findFirst().orElse(null);
        }
        if (context == null) {
            context = this.params.values().stream().filter(c -> {
                if (c.location == null || location == null) {
                    return c.name != null && c.name.equals(name);
                }
                return false;
            }).findFirst().orElse(null);
        }
        return context;
    }

    void readParameters(ClassInfo clazz, AnnotationInstance beanParamAnnotation) {
        for (Map.Entry entry : clazz.annotations().entrySet()) {
            DotName name = (DotName)entry.getKey();
            if (!OpenApiConstants.DOTNAME_PARAMETER.equals((Object)name) && !JaxRsParameter.isParameter(name)) continue;
            for (AnnotationInstance annotation : (List)entry.getValue()) {
                if (!this.isBeanPropertyParam(annotation)) continue;
                this.readAnnotatedType(annotation, beanParamAnnotation);
            }
        }
    }

    boolean isBeanPropertyParam(AnnotationInstance annotation) {
        AnnotationTarget target = annotation.target();
        boolean relevant = false;
        switch (target.kind()) {
            case FIELD: {
                FieldInfo field = target.asField();
                relevant = ParameterProcessor.hasParameters(field.annotations());
                break;
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo param = target.asMethodParameter();
                relevant = !ParameterProcessor.isResourceMethod(param.method()) && ParameterProcessor.hasParameters(TypeUtil.getAnnotations((AnnotationTarget)param)) && !this.isSubResourceLocator(param.method());
                break;
            }
            case METHOD: {
                MethodInfo method = target.asMethod();
                relevant = !ParameterProcessor.isResourceMethod(method) && ParameterProcessor.hasParameters(method.annotations()) && ParameterProcessor.getType(target) != null && !this.isSubResourceLocator(method);
                break;
            }
        }
        return relevant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSubResourceLocator(MethodInfo method) {
        if (method.returnType().kind() != Type.Kind.CLASS) return false;
        if (!method.hasAnnotation(OpenApiConstants.DOTNAME_PATH)) return false;
        if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(OpenApiConstants.DOTNAME_JAXRS_HTTP_METHODS::contains)) return false;
        return true;
    }

    static boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(OpenApiConstants.DOTNAME_JAXRS_HTTP_METHODS::contains);
    }

    static boolean hasParameters(Collection<AnnotationInstance> annotations) {
        return annotations.stream().map(AnnotationInstance::name).anyMatch(ParameterProcessor::isParameter);
    }

    static boolean isParameter(DotName annotationName) {
        if (JaxRsParameter.isParameter(annotationName)) {
            return true;
        }
        if (OpenApiConstants.DOTNAME_PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return OpenApiConstants.DOTNAME_PARAMETERS.equals((Object)annotationName);
    }

    static class ParameterContextKey {
        String name;
        Parameter.In location;

        ParameterContextKey(String name, Parameter.In location) {
            this.name = name;
            this.location = location;
        }

        ParameterContextKey(ParameterContext context) {
            this.name = context.name;
            this.location = context.location;
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location;
        }

        public String getName() {
            return this.name;
        }

        public Parameter.In getLocation() {
            return this.location;
        }
    }

    static class ParameterContext {
        String name;
        Parameter.In location;
        ParameterImpl oaiParam;
        JaxRsParameter jaxRsParam;
        Object jaxRsDefaultValue;
        AnnotationTarget target;
        Type targetType;

        ParameterContext() {
        }

        public String toString() {
            return "name: " + this.name + "; in: " + this.location + "; target: " + this.target;
        }
    }

    public static enum JaxRsParameter {
        PATH_PARAM(OpenApiConstants.DOTNAME_PATH_PARAM, Parameter.In.PATH, null),
        MATRIX_PARAM(OpenApiConstants.DOTNAME_MATRIX_PARAM, Parameter.In.PATH, Parameter.Style.MATRIX),
        QUERY_PARAM(OpenApiConstants.DOTNAME_QUERY_PARAM, Parameter.In.QUERY, null),
        FORM_PARAM(OpenApiConstants.DOTNAME_FORM_PARAM, null, Parameter.Style.FORM),
        HEADER_PARAM(OpenApiConstants.DOTNAME_HEADER_PARAM, Parameter.In.HEADER, null),
        COOKIE_PARAM(OpenApiConstants.DOTNAME_COOKIE_PARAM, Parameter.In.COOKIE, null),
        BEAN_PARAM(OpenApiConstants.DOTNAME_BEAN_PARAM, null, null),
        RESTEASY_PATH_PARAM(OpenApiConstants.DOTNAME_RESTEASY_PATH_PARAM, Parameter.In.PATH, null),
        RESTEASY_MATRIX_PARAM(OpenApiConstants.DOTNAME_RESTEASY_MATRIX_PARAM, Parameter.In.PATH, Parameter.Style.MATRIX),
        RESTEASY_QUERY_PARAM(OpenApiConstants.DOTNAME_RESTEASY_QUERY_PARAM, Parameter.In.QUERY, null),
        RESTEASY_FORM_PARAM(OpenApiConstants.DOTNAME_RESTEASY_FORM_PARAM, null, Parameter.Style.FORM),
        RESTEASY_HEADER_PARAM(OpenApiConstants.DOTNAME_RESTEASY_HEADER_PARAM, Parameter.In.HEADER, null),
        RESTEASY_COOKIE_PARAM(OpenApiConstants.DOTNAME_RESTEASY_COOKIE_PARAM, Parameter.In.COOKIE, null),
        RESTEASY_MULITIPART_FORM(OpenApiConstants.DOTNAME_RESTEASY_MULTIPART_FORM, null, null, "multipart/form-data");

        private final DotName name;
        final Parameter.In location;
        final Parameter.Style style;
        final String mediaType;

        private JaxRsParameter(DotName name, Parameter.In location, Parameter.Style style, String mediaType) {
            this.name = name;
            this.location = location;
            this.style = style;
            this.mediaType = mediaType;
        }

        private JaxRsParameter(DotName name, Parameter.In location, Parameter.Style style) {
            this(name, location, style, null);
        }

        static JaxRsParameter forName(DotName annotationName) {
            for (JaxRsParameter value : JaxRsParameter.values()) {
                if (!value.name.equals((Object)annotationName)) continue;
                return value;
            }
            return null;
        }

        public static boolean isParameter(DotName annotationName) {
            for (JaxRsParameter value : JaxRsParameter.values()) {
                if (!value.name.equals((Object)annotationName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ResourceParameters {
        private String pathItemPath;
        private List<Parameter> pathItemParameters;
        private String operationPath;
        private List<Parameter> operationParameters;
        private Content formBodyContent;

        public List<Parameter> getPathItemParameters() {
            return this.pathItemParameters;
        }

        public String getOperationPath() {
            return this.pathItemPath + this.operationPath;
        }

        public List<Parameter> getOperationParameters() {
            return this.operationParameters;
        }

        public Content getFormBodyContent() {
            return this.formBodyContent;
        }

        public Schema getFormBodySchema() {
            if (this.formBodyContent != null) {
                return ((MediaType)this.formBodyContent.getMediaTypes().values().iterator().next()).getSchema();
            }
            return null;
        }

        void setPathItemPath(String pathItemPath) {
            this.pathItemPath = pathItemPath;
        }

        void setPathItemParameters(List<Parameter> pathItemParameters) {
            this.pathItemParameters = pathItemParameters;
        }

        void setOperationPath(String operationPath) {
            this.operationPath = operationPath;
        }

        void setOperationParameters(List<Parameter> operationParameters) {
            this.operationParameters = operationParameters;
        }

        void setFormBodyContent(Content formBodyContent) {
            this.formBodyContent = formBodyContent;
        }
    }
}

