/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public class SingleRunOperation<Original, E, R, S extends BaseStream<R, S>, S2 extends S>
extends BaseTerminalOperation<Original>
implements TerminalOperation<Original, E> {
    private final Function<? super S2, ? extends E> function;
    private transient AtomicBoolean complete;

    public SingleRunOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<Original>> supplier, Function<? super S2, ? extends E> function) {
        super(intermediateOperations, supplier);
        this.function = function;
        this.complete = new AtomicBoolean();
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return !this.complete.get();
    }

    @Override
    public E performOperation() {
        BaseStream stream = (BaseStream)this.supplier.get();
        for (IntermediateOperation intOp : this.intermediateOperations) {
            stream = intOp.perform(stream);
        }
        E value = this.function.apply(stream);
        this.complete.set(true);
        return value;
    }

    public Function<? super S2, ? extends E> getFunction() {
        return this.function;
    }
}

