/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfoImpl;
import org.infinispan.transaction.xa.recovery.PreparedTxIterator;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryManagerImpl
implements RecoveryManager {
    private static final Log log = LogFactory.getLog(RecoveryManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile RpcManager rpcManager;
    private volatile CommandsFactory commandFactory;
    private final ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> inDoubtTransactions;
    private final String cacheName;
    private ComponentRef<TransactionTable> txTable;
    private TransactionCoordinator txCoordinator;
    private TransactionFactory txFactory;
    private volatile boolean broadcastForPreparedTx = true;

    public RecoveryManagerImpl(ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryHolder, String cacheName) {
        this.inDoubtTransactions = recoveryHolder;
        this.cacheName = cacheName;
    }

    @Inject
    public void init(RpcManager rpcManager, CommandsFactory commandsFactory, ComponentRef<TransactionTable> txTable, TransactionCoordinator txCoordinator, TransactionFactory txFactory) {
        this.rpcManager = rpcManager;
        this.commandFactory = commandsFactory;
        this.txTable = txTable;
        this.txCoordinator = txCoordinator;
        this.txFactory = txFactory;
    }

    @Override
    public RecoveryManager.RecoveryIterator getPreparedTransactionsFromCluster() {
        PreparedTxIterator iterator = new PreparedTxIterator();
        iterator.add(this.recoveryAwareTxTable().getLocalPreparedXids());
        iterator.add(this.getInDoubtTransactions());
        if (this.notOnlyMeInTheCluster() && this.broadcastForPreparedTx) {
            boolean success = true;
            Map<Address, Response> responses = this.getAllPreparedTxFromCluster();
            for (Map.Entry<Address, Response> rEntry : responses.entrySet()) {
                Response thisResponse = rEntry.getValue();
                if (this.isSuccessful(thisResponse)) {
                    List responseValue = (List)((SuccessfulResponse)thisResponse).getResponseValue();
                    if (trace) {
                        log.tracef("Received Xid lists %s from node %s", responseValue, rEntry.getKey());
                    }
                    iterator.add(responseValue);
                    continue;
                }
                log.missingListPreparedTransactions(rEntry.getKey(), rEntry.getValue());
                success = false;
            }
            boolean bl = this.broadcastForPreparedTx = !success;
            if (!this.broadcastForPreparedTx) {
                log.debug("Finished broadcasting for remote prepared transactions. Returning only local values from now on.");
            }
        }
        return iterator;
    }

    @Override
    public void removeRecoveryInformation(Collection<Address> lockOwners, Xid xid, boolean sync, GlobalTransaction gtx, boolean fromCluster) {
        log.tracef("Forgetting tx information for %s", gtx);
        if (this.rpcManager != null && !fromCluster) {
            TxCompletionNotificationCommand ftc = this.commandFactory.buildTxCompletionNotificationCommand(xid, gtx);
            this.rpcManager.invokeRemotely(lockOwners, ftc, this.rpcManager.getDefaultRpcOptions(sync, DeliverOrder.NONE));
        }
        this.removeRecoveryInformation(xid);
    }

    @Override
    public void removeRecoveryInformationFromCluster(Collection<Address> where, long internalId, boolean sync) {
        if (this.rpcManager != null) {
            TxCompletionNotificationCommand ftc = this.commandFactory.buildTxCompletionNotificationCommand(internalId);
            this.rpcManager.invokeRemotely(where, ftc, this.rpcManager.getDefaultRpcOptions(sync, DeliverOrder.NONE));
        }
        this.removeRecoveryInformation(internalId);
    }

    @Override
    public RecoveryAwareTransaction removeRecoveryInformation(Xid xid) {
        RecoveryAwareTransaction remove = (RecoveryAwareTransaction)this.inDoubtTransactions.remove(new RecoveryInfoKey(xid, this.cacheName));
        log.tracef("removed in doubt xid: %s", xid);
        if (remove == null) {
            return (RecoveryAwareTransaction)((Object)this.recoveryAwareTxTable().removeRemoteTransaction(xid));
        }
        return remove;
    }

    @Override
    public RecoveryAwareTransaction removeRecoveryInformation(Long internalId) {
        Xid remoteTransactionXid = this.recoveryAwareTxTable().getRemoteTransactionXid(internalId);
        if (remoteTransactionXid != null) {
            return this.removeRecoveryInformation(remoteTransactionXid);
        }
        for (RecoveryAwareRemoteTransaction raRemoteTx : this.inDoubtTransactions.values()) {
            RecoverableTransactionIdentifier globalTransaction = (RecoverableTransactionIdentifier)((Object)raRemoteTx.getGlobalTransaction());
            if (!internalId.equals(globalTransaction.getInternalId())) continue;
            Xid xid = globalTransaction.getXid();
            log.tracef("Found transaction xid %s that maps internal id %s", xid, internalId);
            this.removeRecoveryInformation(xid);
            return raRemoteTx;
        }
        log.tracef("Could not find tx to map to internal id %s", internalId);
        return null;
    }

    @Override
    public List<Xid> getInDoubtTransactions() {
        ArrayList<Xid> result = new ArrayList<Xid>();
        Set recoveryInfoKeys = this.inDoubtTransactions.keySet();
        for (RecoveryInfoKey key : recoveryInfoKeys) {
            if (!key.cacheName.equals(this.cacheName)) continue;
            result.add(key.xid);
        }
        log.tracef("Returning %s ", result);
        return result;
    }

    @Override
    public Set<RecoveryManager.InDoubtTxInfo> getInDoubtTransactionInfo() {
        List<Xid> txs = this.getInDoubtTransactions();
        Set<RecoveryAwareLocalTransaction> localTxs = this.recoveryAwareTxTable().getLocalTxThatFailedToComplete();
        log.tracef("Local transactions that failed to complete is %s", localTxs);
        HashSet<RecoveryManager.InDoubtTxInfo> result = new HashSet<RecoveryManager.InDoubtTxInfo>();
        for (RecoveryAwareLocalTransaction r : localTxs) {
            long internalId = ((RecoverableTransactionIdentifier)((Object)r.getGlobalTransaction())).getInternalId();
            result.add(new InDoubtTxInfoImpl(r.getXid(), internalId));
        }
        for (Xid xid : txs) {
            RecoveryAwareRemoteTransaction pTx = this.getPreparedTransaction(xid);
            if (pTx == null) continue;
            RecoverableTransactionIdentifier gtx = (RecoverableTransactionIdentifier)((Object)pTx.getGlobalTransaction());
            InDoubtTxInfoImpl infoInDoubt = new InDoubtTxInfoImpl(xid, (Long)gtx.getInternalId(), pTx.getStatus());
            result.add(infoInDoubt);
        }
        log.tracef("The set of in-doubt txs from this node is %s", result);
        return result;
    }

    @Override
    public Set<RecoveryManager.InDoubtTxInfo> getInDoubtTransactionInfoFromCluster() {
        HashMap<Xid, InDoubtTxInfoImpl> result = new HashMap<Xid, InDoubtTxInfoImpl>();
        if (this.rpcManager != null) {
            GetInDoubtTxInfoCommand inDoubtTxInfoCommand = this.commandFactory.buildGetInDoubtTxInfoCommand();
            Map<Address, Response> addressResponseMap = this.rpcManager.invokeRemotely(null, inDoubtTxInfoCommand, this.rpcManager.getDefaultRpcOptions(true));
            for (Map.Entry<Address, Response> re : addressResponseMap.entrySet()) {
                Response r = re.getValue();
                if (!this.isSuccessful(r)) {
                    throw new CacheException("Could not fetch in doubt transactions: " + r);
                }
                Set infoInDoubtSet = (Set)((SuccessfulResponse)r).getResponseValue();
                for (InDoubtTxInfoImpl infoInDoubt : infoInDoubtSet) {
                    InDoubtTxInfoImpl inDoubtTxInfo = (InDoubtTxInfoImpl)result.get(infoInDoubt.getXid());
                    if (inDoubtTxInfo == null) {
                        inDoubtTxInfo = infoInDoubt;
                        result.put(infoInDoubt.getXid(), inDoubtTxInfo);
                    } else {
                        inDoubtTxInfo.addStatus(infoInDoubt.getStatus());
                    }
                    inDoubtTxInfo.addOwner(re.getKey());
                }
            }
        }
        Set<RecoveryManager.InDoubtTxInfo> onThisNode = this.getInDoubtTransactionInfo();
        Iterator<RecoveryManager.InDoubtTxInfo> iterator = onThisNode.iterator();
        while (iterator.hasNext()) {
            RecoveryManager.InDoubtTxInfo info = iterator.next();
            InDoubtTxInfoImpl inDoubtTxInfo = (InDoubtTxInfoImpl)result.get(info.getXid());
            if (inDoubtTxInfo != null) {
                inDoubtTxInfo.setLocal(true);
                iterator.remove();
                continue;
            }
            ((InDoubtTxInfoImpl)info).setLocal(true);
        }
        HashSet<RecoveryManager.InDoubtTxInfo> value = new HashSet<RecoveryManager.InDoubtTxInfo>(result.values());
        value.addAll(onThisNode);
        return value;
    }

    @Override
    public void registerInDoubtTransaction(RecoveryAwareRemoteTransaction remoteTransaction) {
        Xid xid = ((RecoverableTransactionIdentifier)((Object)remoteTransaction.getGlobalTransaction())).getXid();
        RecoveryAwareTransaction previous = this.inDoubtTransactions.put(new RecoveryInfoKey(xid, this.cacheName), remoteTransaction);
        if (previous != null) {
            log.preparedTxAlreadyExists(previous, remoteTransaction);
            throw new IllegalStateException("Are there two different transactions having same Xid in the cluster?");
        }
    }

    @Override
    public RecoveryAwareRemoteTransaction getPreparedTransaction(Xid xid) {
        return (RecoveryAwareRemoteTransaction)this.inDoubtTransactions.get(new RecoveryInfoKey(xid, this.cacheName));
    }

    @Override
    public String forceTransactionCompletion(Xid xid, boolean commit) {
        LocalXaTransaction localTransaction = this.recoveryAwareTxTable().getLocalTransaction(xid);
        if (localTransaction != null) {
            localTransaction.clearRemoteLocksAcquired();
            return this.completeTransaction(localTransaction, commit, xid);
        }
        RecoveryAwareRemoteTransaction tx = this.getPreparedTransaction(xid);
        if (tx == null) {
            return "Could not find transaction " + xid;
        }
        GlobalTransaction globalTransaction = tx.getGlobalTransaction();
        globalTransaction.setAddress(this.rpcManager.getAddress());
        globalTransaction.setRemote(false);
        RecoveryAwareLocalTransaction localTx = (RecoveryAwareLocalTransaction)this.txFactory.newLocalTransaction(null, globalTransaction, false, tx.getTopologyId());
        localTx.setModifications(tx.getModifications());
        localTx.setXid(xid);
        localTx.addAllAffectedKeys(tx.getAffectedKeys());
        for (Object lk : tx.getLockedKeys()) {
            localTx.registerLockedKey(lk);
        }
        return this.completeTransaction(localTx, commit, xid);
    }

    private String completeTransaction(LocalTransaction localTx, boolean commit, Xid xid) {
        if (commit) {
            try {
                localTx.clearLookedUpEntries();
                this.txCoordinator.prepare(localTx, true);
                this.txCoordinator.commit(localTx, false);
            }
            catch (XAException e) {
                log.warnCouldNotCommitLocalTx(localTx, e);
                return "Could not commit transaction " + xid + " : " + e.getMessage();
            }
        }
        try {
            this.txCoordinator.rollback(localTx);
        }
        catch (XAException e) {
            log.warnCouldNotRollbackLocalTx(localTx, e);
            return "Could not commit transaction " + xid + " : " + e.getMessage();
        }
        this.removeRecoveryInformation(null, xid, false, localTx.getGlobalTransaction(), false);
        return commit ? "Commit successful!" : "Rollback successful";
    }

    @Override
    public String forceTransactionCompletionFromCluster(Xid xid, Address where, boolean commit) {
        CompleteTransactionCommand ctc = this.commandFactory.buildCompleteTransactionCommand(xid, commit);
        Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(Collections.singleton(where), ctc, this.rpcManager.getDefaultRpcOptions(true));
        if (responseMap.size() != 1 || responseMap.get(where) == null) {
            log.expectedJustOneResponse(responseMap);
            throw new CacheException("Expected response size is 1, received " + responseMap);
        }
        return (String)((SuccessfulResponse)responseMap.get(where)).getResponseValue();
    }

    @Override
    public boolean isTransactionPrepared(GlobalTransaction globalTx) {
        boolean result;
        Xid xid = ((RecoverableTransactionIdentifier)((Object)globalTx)).getXid();
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.recoveryAwareTxTable().getRemoteTransaction(globalTx);
        boolean remotePrepared = remoteTransaction != null && remoteTransaction.isPrepared();
        boolean bl = result = this.inDoubtTransactions.get(new RecoveryInfoKey(xid, this.cacheName)) != null || this.recoveryAwareTxTable().getLocalPreparedXids().contains(xid) || remotePrepared;
        if (trace) {
            log.tracef("Is tx %s prepared? %s", xid, result);
        }
        return result;
    }

    private RecoveryAwareTransactionTable recoveryAwareTxTable() {
        return (RecoveryAwareTransactionTable)this.txTable.running();
    }

    private boolean isSuccessful(Response thisResponse) {
        return thisResponse != null && thisResponse.isValid() && thisResponse.isSuccessful();
    }

    private boolean notOnlyMeInTheCluster() {
        return this.rpcManager != null && this.rpcManager.getTransport().getMembers().size() > 1;
    }

    private Map<Address, Response> getAllPreparedTxFromCluster() {
        GetInDoubtTransactionsCommand command = this.commandFactory.buildGetInDoubtTransactionsCommand();
        Map<Address, Response> addressResponseMap = this.rpcManager.invokeRemotely(null, command, this.rpcManager.getDefaultRpcOptions(true));
        if (trace) {
            log.tracef("getAllPreparedTxFromCluster received from cluster: %s", addressResponseMap);
        }
        return addressResponseMap;
    }

    public ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> getInDoubtTransactionsMap() {
        return this.inDoubtTransactions;
    }
}

