/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;
import java.util.function.Function;

class AccessLogAttribute
implements Comparable<AccessLogAttribute> {
    private final String key;
    private final ExchangeAttribute exchangeAttribute;
    private final Function<String, Object> valueConverter;

    private AccessLogAttribute(String key, ExchangeAttribute exchangeAttribute, Function<String, Object> valueConverter) {
        this.key = key;
        this.exchangeAttribute = exchangeAttribute;
        this.valueConverter = valueConverter;
    }

    static AccessLogAttribute of(String key, ExchangeAttribute exchangeAttribute) {
        return new AccessLogAttribute(key, exchangeAttribute, null);
    }

    static AccessLogAttribute of(String key, ExchangeAttribute exchangeAttribute, Function<String, Object> valueConverter) {
        return new AccessLogAttribute(key, exchangeAttribute, valueConverter);
    }

    String getKey() {
        return this.key;
    }

    Object resolveAttribute(HttpServerExchange exchange) {
        if (this.valueConverter == null) {
            return this.exchangeAttribute.readAttribute(exchange);
        }
        return this.valueConverter.apply(this.exchangeAttribute.readAttribute(exchange));
    }

    @Override
    public int compareTo(AccessLogAttribute o) {
        return this.key.compareTo(o.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessLogAttribute)) {
            return false;
        }
        AccessLogAttribute other = (AccessLogAttribute)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{key=" + this.key + ", exchangeAttribute=" + this.exchangeAttribute + ", valueConverter=" + this.valueConverter + "}";
    }
}

